/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.ReaderCache;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.parameters.lucene.sort.JiraLuceneFieldFinder;
import com.atlassian.jira.issue.statistics.util.HitCollectorUtil;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;

@Internal
public abstract class AbstractOneDimensionalHitCollector
extends Collector {
    private static final Logger log = Logger.getLogger(AbstractOneDimensionalHitCollector.class);
    private final String fieldId;
    private Collection<String>[] docToTerms;
    private Collection<String>[] docToProject;
    private Collection<String>[] docToIssueType;
    private String documentFieldId;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final ProjectManager projectManager;
    private final ReaderCache readerCache;
    private long irrelevantCount = 0L;
    private boolean usingOldCallingConvention = false;
    private final CustomField customField;
    private Map<String, Map<String, Boolean>> projectIdIssueTypeIdFieldVisibility = new HashMap<String, Map<String, Boolean>>();
    private long hitCount = 0L;
    private int docBase = 0;

    public AbstractOneDimensionalHitCollector(String documentFieldId, IndexReader indexReader, FieldVisibilityManager fieldVisibilityManager, ReaderCache readerCache, FieldManager fieldManager, ProjectManager projectManager) {
        this.documentFieldId = documentFieldId;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.readerCache = readerCache;
        this.fieldId = new HitCollectorUtil().getFieldId(documentFieldId);
        this.projectManager = projectManager;
        this.setNextReader(indexReader, 0);
        this.usingOldCallingConvention = true;
        this.customField = fieldManager.isCustomField(this.fieldId) ? fieldManager.getCustomField(this.fieldId) : null;
    }

    public AbstractOneDimensionalHitCollector(String documentFieldId, FieldVisibilityManager fieldVisibilityManager, ReaderCache readerCache, FieldManager fieldManager, ProjectManager projectManager) {
        this.documentFieldId = documentFieldId;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.projectManager = projectManager;
        this.readerCache = readerCache;
        this.fieldId = new HitCollectorUtil().getFieldId(documentFieldId);
        this.customField = fieldManager.isCustomField(this.fieldId) ? fieldManager.getCustomField(this.fieldId) : null;
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public void setNextReader(IndexReader reader, int docBase) {
        if (this.usingOldCallingConvention) {
            log.warn((Object)"You constructed an instance of AbstractOneDimensionalHitCollector using the old calling convention and passed in an index reader.  You should not be calling setNextReader() on that instance as it will cause excessive double caching of data.  This is a BAD BAD THING!!!");
        }
        this.docBase = docBase;
        this.docToTerms = AbstractOneDimensionalHitCollector.readCachedMultiValueField(reader, this.documentFieldId, this.readerCache);
        this.docToProject = AbstractOneDimensionalHitCollector.readCachedSingleValueField(reader, SystemSearchConstants.forProject().getIndexField(), this.readerCache);
        this.docToIssueType = AbstractOneDimensionalHitCollector.readCachedSingleValueField(reader, SystemSearchConstants.forIssueType().getIndexField(), this.readerCache);
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    public void collect(int i) {
        ++this.hitCount;
        Collection<String> terms = this.docToTerms[i];
        if (terms == null) {
            String issueTypeId;
            String projectIdString = AbstractOneDimensionalHitCollector.getSingleValue(this.docToProject[i]);
            if (this.fieldIsRelevant(projectIdString, issueTypeId = AbstractOneDimensionalHitCollector.getSingleValue(this.docToIssueType[i]))) {
                this.collectWithTerms(this.docBase + i, null);
            } else {
                ++this.irrelevantCount;
                this.collectIrrelevant(this.docBase + i);
            }
        } else {
            this.collectWithTerms(this.docBase + i, terms);
        }
    }

    private boolean fieldIsRelevant(String projectIdString, String issueTypeId) {
        Boolean fieldRelevant;
        Map<String, Boolean> issueTypeIdFieldVisibility = this.projectIdIssueTypeIdFieldVisibility.get(projectIdString);
        if (issueTypeIdFieldVisibility == null) {
            issueTypeIdFieldVisibility = new HashMap<String, Boolean>();
            this.projectIdIssueTypeIdFieldVisibility.put(projectIdString, issueTypeIdFieldVisibility);
        }
        if ((fieldRelevant = issueTypeIdFieldVisibility.get(issueTypeId)) == null) {
            Long projectId = Long.valueOf(projectIdString);
            fieldRelevant = this.fieldVisibilityManager.isFieldVisible(projectId, this.fieldId, issueTypeId) && this.isFieldInScope(projectId, issueTypeId);
            issueTypeIdFieldVisibility.put(issueTypeId, fieldRelevant);
        }
        return fieldRelevant;
    }

    private boolean isFieldInScope(Long projectId, String issueTypeId) {
        if (this.fieldId == null || "".equals(this.fieldId) || projectId == null || issueTypeId == null || "".equals(issueTypeId)) {
            return false;
        }
        if (this.customField == null) {
            return true;
        }
        Project project = this.projectManager.getProjectObj(projectId);
        if (project == null) {
            return false;
        }
        ArrayList<String> issueTypeIds = new ArrayList<String>();
        issueTypeIds.add(issueTypeId);
        return this.customField.isInScope(project, issueTypeIds);
    }

    private static String getSingleValue(Collection<String> source) {
        return source instanceof List ? (String)((List)source).get(0) : source.iterator().next();
    }

    public long getIrrelevantCount() {
        return this.irrelevantCount;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    protected abstract void collectIrrelevant(int var1);

    protected abstract void collectWithTerms(int var1, Collection<String> var2);

    private static Collection<String>[] readCachedMultiValueField(final IndexReader indexReader, final String fieldId, ReaderCache readerCache) {
        return readerCache.get(indexReader, fieldId, new Supplier<Collection<String>[]>(){

            @Override
            public Collection<String>[] get() {
                try {
                    return JiraLuceneFieldFinder.getInstance().getMatches(indexReader, fieldId);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
        });
    }

    private static Collection<String>[] readCachedSingleValueField(final IndexReader indexReader, final String fieldId, ReaderCache readerCache) {
        return readerCache.get(indexReader, fieldId, new Supplier<Collection<String>[]>(){

            @Override
            public Collection<String>[] get() {
                try {
                    return JiraLuceneFieldFinder.getInstance().getUniqueMatches(indexReader, fieldId);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
        });
    }
}

