/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.mapper;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.external.beans.ExternalUser;
import com.atlassian.jira.imports.project.mapper.AbstractMapper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

@PublicApi
public class UserMapper
extends AbstractMapper {
    private final Map<String, ExternalUser> users;
    private final Set<String> usersInUse;
    private final UserUtil userUtil;

    public UserMapper(UserUtil userUtil) {
        this.userUtil = userUtil;
        this.users = Maps.newHashMap();
        this.usersInUse = Sets.newHashSet();
    }

    public void registerOldValue(ExternalUser externalUser) {
        Assertions.notNull("externalUser", externalUser);
        super.registerOldValue(externalUser.getKey(), externalUser.getName());
        this.users.put(externalUser.getKey(), externalUser);
    }

    public ExternalUser getExternalUser(String userKey) {
        return this.users.get(userKey);
    }

    @Override
    public String getMappedId(String oldId) {
        if (this.userExists(oldId)) {
            return oldId;
        }
        return null;
    }

    public void flagUserAsMandatory(String oldUserKey) {
        super.flagValueAsRequired(oldUserKey);
        this.usersInUse.remove(oldUserKey);
    }

    public void flagUserAsInUse(String oldUserKey) {
        if (!this.getRequiredOldIds().contains(oldUserKey)) {
            this.usersInUse.add(oldUserKey);
        }
    }

    public Collection<ExternalUser> getUnmappedMandatoryUsers() {
        ArrayList<ExternalUser> unmappedUsers = new ArrayList<ExternalUser>();
        for (String userKey : this.getRequiredOldIds()) {
            if (this.userExists(userKey)) continue;
            ExternalUser user = this.users.get(userKey);
            if (user == null) {
                user = this.externalUser(userKey);
            }
            unmappedUsers.add(user);
        }
        return unmappedUsers;
    }

    public List<ExternalUser> getUnmappedMandatoryUsersWithNoRegisteredOldValue() {
        ArrayList<ExternalUser> unregisteredUsers = new ArrayList<ExternalUser>();
        for (String userKey : this.getRequiredOldIds()) {
            ExternalUser user;
            if (this.userExists(userKey) || (user = this.users.get(userKey)) != null) continue;
            unregisteredUsers.add(this.externalUser(userKey));
        }
        return unregisteredUsers;
    }

    public List<ExternalUser> getUnmappedUsersInUseWithNoRegisteredOldValue() {
        ArrayList<ExternalUser> unregisteredUsers = new ArrayList<ExternalUser>();
        for (String userKey : this.usersInUse) {
            ExternalUser user;
            if (this.userExists(userKey) || (user = this.users.get(userKey)) != null) continue;
            unregisteredUsers.add(this.externalUser(userKey));
        }
        return unregisteredUsers;
    }

    public Collection<ExternalUser> getUnmappedUsersInUse() {
        ArrayList<ExternalUser> unmappedUsers = new ArrayList<ExternalUser>();
        for (String userKey : this.usersInUse) {
            if (this.userExists(userKey)) continue;
            ExternalUser user = this.users.get(userKey);
            if (user == null) {
                user = this.externalUser(userKey);
            }
            unmappedUsers.add(user);
        }
        return unmappedUsers;
    }

    private ExternalUser externalUser(String userKey) {
        return new ExternalUser(userKey, this.getMappedUserName(userKey), "", "", "");
    }

    public Collection<ExternalUser> getUsersToAutoCreate() {
        ExternalUser user;
        ArrayList<ExternalUser> autoCreatable = new ArrayList<ExternalUser>();
        for (String userKey : this.getRequiredOldIds()) {
            if (this.userExists(userKey) || (user = this.users.get(userKey)) == null) continue;
            autoCreatable.add(user);
        }
        for (String userKey : this.usersInUse) {
            if (this.userExists(userKey) || (user = this.users.get(userKey)) == null) continue;
            autoCreatable.add(user);
        }
        return autoCreatable;
    }

    public Collection<String> getOptionalOldIds() {
        return this.usersInUse;
    }

    public boolean userExists(String userKey) {
        String userName = this.getMappedUserName(userKey);
        return userName != null && this.userUtil.userExists(userName);
    }

    public String getMappedUserKey(String oldUserKey) {
        ApplicationUser user;
        String userName = this.getMappedUserName(oldUserKey);
        if (userName != null && (user = this.userUtil.getUserByName(userName)) != null) {
            return user.getKey();
        }
        return oldUserKey;
    }

    private String getMappedUserName(String userKey) {
        String userName = this.getKey(userKey);
        return userName == null ? userKey : userName;
    }
}

