/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.plugin;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.security.Permissions;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

@ExperimentalApi
public final class ProjectPermissionKey {
    private final String permissionKey;

    public ProjectPermissionKey(int permissionId) {
        this(ProjectPermissionKey.resolve(permissionId));
    }

    public ProjectPermissionKey(@Nonnull String permissionKey) {
        this.permissionKey = (String)Preconditions.checkNotNull((Object)permissionKey);
    }

    public String permissionKey() {
        return this.permissionKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectPermissionKey that = (ProjectPermissionKey)o;
        return this.permissionKey.equals(that.permissionKey);
    }

    public int hashCode() {
        return this.permissionKey != null ? this.permissionKey.hashCode() : 0;
    }

    private static String resolve(Integer permissionId) {
        String name = Permissions.getShortName(permissionId);
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("No permission for id : " + permissionId + " in system");
        }
        return name;
    }
}

