/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.statistics;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.customfields.converters.SelectConverter;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.statistics.CascadingOption;
import com.atlassian.jira.issue.customfields.statistics.CascadingOptionComparator;
import com.atlassian.jira.issue.customfields.statistics.CascadingOptionValueComparator;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestAppender;
import com.atlassian.jira.issue.search.util.SearchRequestAddendumBuilder;
import com.atlassian.jira.issue.statistics.ValueStatisticMapper;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operator.Operator;
import java.util.Comparator;

@Internal
public class CascadingSelectStatisticsMapper
implements ValueStatisticMapper<CascadingOption>,
SearchRequestAppender.Factory<CascadingOption> {
    public static final String SUB_VALUE_SUFFIX = "_combined";
    public static final String PARENT_AND_CHILD_INDEX_SEPARATOR = "|";
    private final CustomField customField;
    private final ClauseNames clauseNames;
    private final SelectConverter selectConverter;
    private JiraAuthenticationContext authenticationContext;
    private CustomFieldInputHelper customFieldInputHelper;

    public CascadingSelectStatisticsMapper(CustomField customField, SelectConverter selectConverter, JiraAuthenticationContext authenticationContext, CustomFieldInputHelper customFieldInputHelper) {
        this.authenticationContext = authenticationContext;
        this.customFieldInputHelper = customFieldInputHelper;
        this.customField = Assertions.notNull("customField", customField);
        this.clauseNames = customField.getClauseNames();
        this.selectConverter = Assertions.notNull("selectConverter", selectConverter);
    }

    @Override
    public String getDocumentConstant() {
        return this.customField.getId() + SUB_VALUE_SUFFIX;
    }

    @Override
    public CascadingOption getValueFromLuceneField(String documentValue) {
        if (documentValue == null || "".equals(documentValue)) {
            return null;
        }
        String[] valueSections = documentValue.split("\\|");
        switch (valueSections.length) {
            case 0: {
                return null;
            }
            case 1: {
                Option onlyParent = this.selectConverter.getObject(valueSections[0]);
                return new CascadingOption(onlyParent, null);
            }
            case 2: {
                Option parent = this.selectConverter.getObject(valueSections[0]);
                Option child = this.selectConverter.getObject(valueSections[1]);
                return new CascadingOption(parent, child);
            }
        }
        throw new FieldValidationException("Option Id '" + documentValue + "' is not a valid cascading select pair.");
    }

    @Override
    public Comparator<CascadingOption> getComparator() {
        return new CascadingOptionComparator();
    }

    @Override
    public SearchRequestAppender<CascadingOption> getSearchRequestAppender() {
        return new SelectCascadingOptionSearchRequestAppender(this.customFieldInputHelper.getUniqueClauseName(this.authenticationContext.getLoggedInUser(), this.clauseNames.getPrimaryName(), this.customField.getName()));
    }

    @Override
    public Comparator<CascadingOption> getValueComparator() {
        return new CascadingOptionValueComparator();
    }

    @Override
    public boolean isValidValue(CascadingOption value) {
        return true;
    }

    @Override
    public boolean isFieldAlwaysPartOfAnIssue() {
        return false;
    }

    @Override
    @Deprecated
    public SearchRequest getSearchUrlSuffix(CascadingOption option, SearchRequest searchRequest) {
        return this.getSearchRequestAppender().appendInclusiveSingleValueClause(option, searchRequest);
    }

    @Override
    public int hashCode() {
        int result = this.customField.getId().hashCode();
        result = 31 * result + this.clauseNames.hashCode();
        return result;
    }

    static class SelectCascadingOptionSearchRequestAppender
    implements SearchRequestAddendumBuilder.AddendumCallback<CascadingOption>,
    SearchRequestAppender<CascadingOption> {
        final String clauseName;

        public SelectCascadingOptionSearchRequestAppender(String clauseName) {
            this.clauseName = Assertions.notNull(clauseName);
        }

        @Override
        public void appendNonNullItem(CascadingOption value, JqlClauseBuilder clauseBuilder) {
            if (value.getChild() == null) {
                clauseBuilder.addFunctionCondition(this.clauseName, Operator.IN, "cascadeOption", value.getParent().getValue(), "none");
            } else {
                clauseBuilder.addFunctionCondition(this.clauseName, Operator.IN, "cascadeOption", value.getParent().getValue().toString(), value.getChild().getValue().toString());
            }
        }

        @Override
        public void appendNullItem(JqlClauseBuilder clauseBuilder) {
            clauseBuilder.addEmptyCondition(this.clauseName);
        }

        @Override
        public SearchRequest appendInclusiveSingleValueClause(CascadingOption value, SearchRequest searchRequest) {
            return SearchRequestAddendumBuilder.appendAndClause(value, searchRequest, this);
        }

        @Override
        public SearchRequest appendExclusiveMultiValueClause(Iterable values, SearchRequest searchRequest) {
            return SearchRequestAddendumBuilder.appendAndNotClauses(values, searchRequest, this);
        }
    }
}

