/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.issue.statistics.util.NumericComparator;
import java.util.Comparator;

public class NumericFieldStatisticsMapper
implements StatisticsMapper {
    private final String documentConstant;

    public NumericFieldStatisticsMapper(String documentConstant) {
        this.documentConstant = documentConstant;
    }

    @Override
    public String getDocumentConstant() {
        return this.documentConstant;
    }

    @Override
    public Object getValueFromLuceneField(String documentValue) {
        return new Double(documentValue);
    }

    @Override
    public Comparator getComparator() {
        return NumericComparator.COMPARATOR;
    }

    public boolean isValidValue(Object value) {
        return true;
    }

    @Override
    public boolean isFieldAlwaysPartOfAnIssue() {
        return true;
    }

    public SearchRequest getSearchUrlSuffix(Object value, SearchRequest searchRequest) {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumericFieldStatisticsMapper that = (NumericFieldStatisticsMapper)o;
        return this.getDocumentConstant() != null ? this.getDocumentConstant().equals(that.getDocumentConstant()) : that.getDocumentConstant() == null;
    }

    @Override
    public int hashCode() {
        return this.getDocumentConstant() != null ? this.getDocumentConstant().hashCode() : 0;
    }
}

