/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.ReaderCache;
import com.atlassian.jira.issue.statistics.util.AbstractOneDimensionalHitCollector;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

@Internal
public class OneDimensionalTermHitCollector
extends AbstractOneDimensionalHitCollector {
    private final Map<String, Tally> result = new HashMap<String, Tally>();

    public OneDimensionalTermHitCollector(String fieldId, FieldVisibilityManager fieldVisibilityManager, ReaderCache readerCache, FieldManager fieldManager, ProjectManager projectManager) {
        super(fieldId, fieldVisibilityManager, readerCache, fieldManager, projectManager);
    }

    @Override
    protected void collectIrrelevant(int docId) {
    }

    public Map<String, Integer> getResult() {
        return Maps.transformValues(this.result, (Function)new Function<Tally, Integer>(){

            public Integer apply(@Nullable Tally input) {
                return input.getTally();
            }
        });
    }

    @Override
    protected void collectWithTerms(int docId, Collection<String> terms) {
        if (terms == null) {
            this.incrementCount(null, this.result);
        } else {
            for (String term : terms) {
                this.incrementCount(term, this.result);
            }
        }
    }

    private void incrementCount(String key, Map<String, Tally> map) {
        Tally tally = map.get(key);
        if (tally == null) {
            tally = new Tally();
            map.put(key, tally);
        }
        tally.inc();
    }

    private static class Tally {
        int tally = 0;

        private Tally() {
        }

        private Integer getTally() {
            return this.tally;
        }

        private void inc() {
            ++this.tally;
        }
    }
}

