/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts;

import com.atlassian.jira.charts.PieSegment;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.statistics.FilterStatisticsValuesGenerator;
import com.atlassian.jira.issue.statistics.util.DefaultFieldValueToDisplayTransformer;
import com.atlassian.jira.issue.statistics.util.ObjectToFieldValueMapper;
import com.atlassian.jira.util.I18nHelper;
import org.apache.commons.lang.StringEscapeUtils;

public class PieSegmentWrapper
implements PieSegment {
    private final Object key;
    private final String name;
    private final boolean generateUrl;

    public PieSegmentWrapper(Object key, I18nHelper i18nHelper, String statisticType, ConstantsManager constantsManager, CustomFieldManager customFieldManager) {
        DefaultFieldValueToDisplayTransformer fieldValueToDisplayTransformer = new DefaultFieldValueToDisplayTransformer(i18nHelper, customFieldManager);
        if (key == FilterStatisticsValuesGenerator.IRRELEVANT) {
            this.key = null;
            this.generateUrl = false;
        } else {
            this.key = key;
            this.generateUrl = true;
        }
        this.name = StringEscapeUtils.unescapeHtml((String)ObjectToFieldValueMapper.transform(statisticType, key, null, fieldValueToDisplayTransformer));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Object o) {
        return this.name.compareTo(((PieSegmentWrapper)o).name);
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public boolean isGenerateUrl() {
        return this.generateUrl;
    }
}

