/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.constants;

import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.constants.AllTextSearchConstants;
import com.atlassian.jira.issue.search.constants.CommentsFieldSearchConstants;
import com.atlassian.jira.issue.search.constants.DefaultClauseInformation;
import com.atlassian.jira.issue.search.constants.IssueIdConstants;
import com.atlassian.jira.issue.search.constants.IssueKeyConstants;
import com.atlassian.jira.issue.search.constants.IssueParentConstants;
import com.atlassian.jira.issue.search.constants.SavedFilterSearchConstants;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.constants.UserFieldSearchConstantsWithEmpty;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.jcip.annotations.ThreadSafe;
import org.apache.log4j.Logger;

@ThreadSafe
public final class SystemSearchConstants {
    public static final String QUERY_SEARCHER_ID = "text";
    public static final String FIX_FOR_VERSION = "fixversion";
    public static final String FIX_FOR_VERSION_CHANGEITEM = "Fix Version";
    private static final SimpleFieldSearchConstants PRIORITY = new SimpleFieldSearchConstants("priority", "priority", "priority", "priority", "priority", OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY, JiraDataTypes.PRIORITY);
    private static final SimpleFieldSearchConstants PROJECT = new SimpleFieldSearchConstants("projid", "project", "pid", "project", "project", OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, JiraDataTypes.PROJECT);
    private static final SimpleFieldSearchConstants ISSUE_TYPE = new SimpleFieldSearchConstants("type", new ClauseNames("issuetype", "type"), "type", "issuetype", "issuetype", OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, JiraDataTypes.ISSUE_TYPE);
    private static final SimpleFieldSearchConstantsWithEmpty COMPONENT = new SimpleFieldSearchConstantsWithEmpty("component", new ClauseNames("component"), "component", "component", "-1", "-1", "components", OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, JiraDataTypes.COMPONENT);
    private static final SimpleFieldSearchConstantsWithEmpty AFFECTED_VERSION = new SimpleFieldSearchConstantsWithEmpty("version", new ClauseNames("affectedVersion"), "version", "version", "-1", "-1", "versions", OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY, JiraDataTypes.VERSION);
    private static final SimpleFieldSearchConstantsWithEmpty FIXFOR_VERSION = new SimpleFieldSearchConstantsWithEmpty("fixfor", new ClauseNames("fixVersion"), "fixfor", "fixfor", "-1", "-1", "fixVersions", OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY, JiraDataTypes.VERSION);
    private static final SimpleFieldSearchConstants RESOLUTION = new SimpleFieldSearchConstants("resolution", "resolution", "resolution", "resolution", "resolution", OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY, JiraDataTypes.RESOLUTION);
    private static final SimpleFieldSearchConstants STATUS = new SimpleFieldSearchConstants("status", "status", "status", "status", "status", OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, JiraDataTypes.STATUS);
    private static final SimpleFieldSearchConstants SUMMARY = new SimpleFieldSearchConstants("summary", "summary", "summary", "summary", "summary", OperatorClasses.TEXT_OPERATORS, JiraDataTypes.TEXT);
    private static final SimpleFieldSearchConstants DESCRIPTION = new SimpleFieldSearchConstants("description", "description", "description", "description", "description", OperatorClasses.TEXT_OPERATORS, JiraDataTypes.TEXT);
    private static final SimpleFieldSearchConstants ENVIRONMENT = new SimpleFieldSearchConstants("environment", "environment", "environment", "environment", "environment", OperatorClasses.TEXT_OPERATORS, JiraDataTypes.TEXT);
    private static final SimpleFieldSearchConstantsWithEmpty LABELS = new SimpleFieldSearchConstantsWithEmpty("labels", "labels", "labels", "labels", "<EMPTY>", "<EMPTY>", "labels", OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, JiraDataTypes.LABEL);
    private static final SimpleFieldSearchConstants CREATED_DATE = new SimpleFieldSearchConstants("created", new ClauseNames("created", "createdDate"), "created", "created", "created", OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY, JiraDataTypes.DATE);
    private static final SimpleFieldSearchConstants UPDATE_DATE = new SimpleFieldSearchConstants("updated", new ClauseNames("updated", "updatedDate"), "updated", "updated", "updated", OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY, JiraDataTypes.DATE);
    private static final SimpleFieldSearchConstants LAST_VIEWED_DATE = new SimpleFieldSearchConstants("issue_id", new ClauseNames("lastViewed"), "lastViewed", "lastViewed", "lastViewed", OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY, JiraDataTypes.DATE);
    private static final SimpleFieldSearchConstants DUE_DATE = new SimpleFieldSearchConstants("duedate", new ClauseNames("due", "duedate"), "duedate", "duedate", "duedate", OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY, JiraDataTypes.DATE);
    private static final SimpleFieldSearchConstants RESOLUTION_DATE = new SimpleFieldSearchConstants("resolutiondate", new ClauseNames("resolved", "resolutiondate"), "resolutiondate", "resolutiondate", "resolutiondate", OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY, JiraDataTypes.DATE);
    private static final UserFieldSearchConstantsWithEmpty REPORTER = new UserFieldSearchConstantsWithEmpty("issue_author", "reporter", "reporter", "reporterSelect", "reporter", "issue_no_reporter", "reporter", OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY);
    private static final UserFieldSearchConstantsWithEmpty ASSIGNEE = new UserFieldSearchConstantsWithEmpty("issue_assignee", "assignee", "assignee", "assigneeSelect", "assignee", "unassigned", "assignee", OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY);
    private static final SimpleFieldSearchConstants WORK_RATIO = new SimpleFieldSearchConstants("workratio", "workratio", "workratio", "workratio", "workratio", OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY, JiraDataTypes.NUMBER);
    private static final DefaultClauseInformation CURRENT_ESTIMATE = new DefaultClauseInformation("timeestimate", new ClauseNames("remainingEstimate", "timeestimate"), "timeestimate", OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY, JiraDataTypes.DURATION);
    private static final DefaultClauseInformation ORIGINAL_ESTIMATE = new DefaultClauseInformation("timeoriginalestimate", new ClauseNames("originalEstimate", "timeoriginalestimate"), "timeoriginalestimate", OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY, JiraDataTypes.DURATION);
    private static final DefaultClauseInformation TIME_SPENT = new DefaultClauseInformation("timespent", "timespent", "timespent", OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY, JiraDataTypes.DURATION);
    private static final DefaultClauseInformation SECURITY_LEVEL = new DefaultClauseInformation("issue_security_level", new ClauseNames("level"), "security", OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, JiraDataTypes.ISSUE_SECURITY_LEVEL);
    private static final DefaultClauseInformation VOTES = new DefaultClauseInformation("issue_votes", "votes", "votes", OperatorClasses.EQUALITY_AND_RELATIONAL, JiraDataTypes.NUMBER);
    private static final DefaultClauseInformation VOTERS = new DefaultClauseInformation("issue_voter", "voter", "voter", OperatorClasses.EQUALITY_OPERATORS, JiraDataTypes.USER);
    private static final DefaultClauseInformation WATCHES = new DefaultClauseInformation("issue_watches", new ClauseNames("watchers"), "watches", OperatorClasses.EQUALITY_AND_RELATIONAL, JiraDataTypes.NUMBER);
    private static final DefaultClauseInformation WATCHERS = new DefaultClauseInformation("issue_watcher", "watcher", "watcher", OperatorClasses.EQUALITY_OPERATORS, JiraDataTypes.USER);
    private static final DefaultClauseInformation ATTACHMENT = new DefaultClauseInformation("issue_has_attachment", "attachments", "attachment", OperatorClasses.EMPTY_ONLY_OPERATORS, JiraDataTypes.ATTACHMENT);
    private static final DefaultClauseInformation PROJECT_CATEGORY = new DefaultClauseInformation("projid", "category", null, OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, JiraDataTypes.PROJECT_CATEGORY);
    private static final DefaultClauseInformation PROGRESS = new DefaultClauseInformation("progress", "progress", "progress", OperatorClasses.EQUALITY_AND_RELATIONAL, JiraDataTypes.NUMBER);
    private static final Set<String> SYSTEM_NAMES;
    private static final Map<String, ClauseInformation> CLAUSE_INFORMATION_MAP;

    private SystemSearchConstants() {
    }

    public static SimpleFieldSearchConstants forPriority() {
        return PRIORITY;
    }

    public static SimpleFieldSearchConstants forProject() {
        return PROJECT;
    }

    public static SimpleFieldSearchConstants forIssueType() {
        return ISSUE_TYPE;
    }

    public static SimpleFieldSearchConstantsWithEmpty forComponent() {
        return COMPONENT;
    }

    public static SimpleFieldSearchConstantsWithEmpty forAffectedVersion() {
        return AFFECTED_VERSION;
    }

    public static SimpleFieldSearchConstantsWithEmpty forFixForVersion() {
        return FIXFOR_VERSION;
    }

    public static SimpleFieldSearchConstants forResolution() {
        return RESOLUTION;
    }

    public static SimpleFieldSearchConstants forStatus() {
        return STATUS;
    }

    public static SimpleFieldSearchConstants forSummary() {
        return SUMMARY;
    }

    public static SimpleFieldSearchConstants forDescription() {
        return DESCRIPTION;
    }

    public static SimpleFieldSearchConstants forEnvironment() {
        return ENVIRONMENT;
    }

    public static SimpleFieldSearchConstantsWithEmpty forLabels() {
        return LABELS;
    }

    public static CommentsFieldSearchConstants forComments() {
        return CommentsFieldSearchConstants.getInstance();
    }

    public static SimpleFieldSearchConstants forCreatedDate() {
        return CREATED_DATE;
    }

    public static SimpleFieldSearchConstants forUpdatedDate() {
        return UPDATE_DATE;
    }

    public static SimpleFieldSearchConstants forLastViewedDate() {
        return LAST_VIEWED_DATE;
    }

    public static SimpleFieldSearchConstants forDueDate() {
        return DUE_DATE;
    }

    public static SimpleFieldSearchConstants forResolutionDate() {
        return RESOLUTION_DATE;
    }

    public static UserFieldSearchConstantsWithEmpty forReporter() {
        return REPORTER;
    }

    public static UserFieldSearchConstantsWithEmpty forAssignee() {
        return ASSIGNEE;
    }

    public static SavedFilterSearchConstants forSavedFilter() {
        return SavedFilterSearchConstants.getInstance();
    }

    public static AllTextSearchConstants forAllText() {
        return AllTextSearchConstants.getInstance();
    }

    public static IssueIdConstants forIssueId() {
        return IssueIdConstants.getInstance();
    }

    public static IssueKeyConstants forIssueKey() {
        return IssueKeyConstants.getInstance();
    }

    public static IssueParentConstants forIssueParent() {
        return IssueParentConstants.getInstance();
    }

    public static SimpleFieldSearchConstants forWorkRatio() {
        return WORK_RATIO;
    }

    public static DefaultClauseInformation forCurrentEstimate() {
        return CURRENT_ESTIMATE;
    }

    public static DefaultClauseInformation forOriginalEstimate() {
        return ORIGINAL_ESTIMATE;
    }

    public static DefaultClauseInformation forTimeSpent() {
        return TIME_SPENT;
    }

    public static DefaultClauseInformation forSecurityLevel() {
        return SECURITY_LEVEL;
    }

    public static DefaultClauseInformation forVotes() {
        return VOTES;
    }

    public static DefaultClauseInformation forVoters() {
        return VOTERS;
    }

    public static DefaultClauseInformation forWatches() {
        return WATCHES;
    }

    public static DefaultClauseInformation forWatchers() {
        return WATCHERS;
    }

    public static DefaultClauseInformation forAttachments() {
        return ATTACHMENT;
    }

    public static DefaultClauseInformation forProjectCategory() {
        return PROJECT_CATEGORY;
    }

    public static DefaultClauseInformation forProgress() {
        return PROGRESS;
    }

    public static Set<String> getSystemNames() {
        return SYSTEM_NAMES;
    }

    public static boolean isSystemName(String name) {
        return SYSTEM_NAMES.contains(name);
    }

    public static ClauseInformation getClauseInformationById(String id) {
        return CLAUSE_INFORMATION_MAP.get(id);
    }

    private static Collection<String> getNames(Method constantMethod) {
        try {
            ClauseInformation information = (ClauseInformation)constantMethod.invoke(null, new Object[0]);
            if (information == null) {
                SystemSearchConstants.logConstantError(constantMethod, "Clause information was not available.", null);
                return Collections.emptySet();
            }
            ClauseNames names = information.getJqlClauseNames();
            if (names == null) {
                SystemSearchConstants.logConstantError(constantMethod, "The ClauseName was not available.", null);
                return Collections.emptySet();
            }
            Set<String> strings = names.getJqlFieldNames();
            if (strings == null) {
                SystemSearchConstants.logConstantError(constantMethod, "The ClauseName returned no values.", null);
                return Collections.emptySet();
            }
            return strings;
        }
        catch (InvocationTargetException e) {
            Throwable exception = e.getTargetException() != null ? e.getTargetException() : e;
            SystemSearchConstants.logConstantError(constantMethod, null, exception);
        }
        catch (IllegalAccessException e) {
            SystemSearchConstants.logConstantError(constantMethod, null, e);
        }
        catch (SecurityException e) {
            SystemSearchConstants.logConstantError(constantMethod, "Security Error.", e);
        }
        catch (RuntimeException e) {
            SystemSearchConstants.logConstantError(constantMethod, "Unexpected Error.", e);
        }
        return Collections.emptySet();
    }

    private static Collection<Method> getConstantMethods() {
        Method[] methods;
        try {
            methods = SystemSearchConstants.class.getMethods();
        }
        catch (SecurityException e) {
            SystemSearchConstants.getLogger().error((Object)("Unable to calculate system JQL names: " + e.getMessage()), (Throwable)e);
            return Collections.emptySet();
        }
        ArrayList<Method> returnMethods = new ArrayList<Method>(methods.length);
        for (Method method : methods) {
            Class<?> returnType;
            int modifiers = method.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || method.getParameterTypes().length != 0 || !ClauseInformation.class.isAssignableFrom(returnType = method.getReturnType())) continue;
            returnMethods.add(method);
        }
        return returnMethods;
    }

    private static void logConstantError(Method constantMethod, String msg, Throwable th) {
        String actualMessage = msg;
        if (msg == null && th != null) {
            actualMessage = th.getMessage();
        }
        SystemSearchConstants.getLogger().error((Object)("Unable to calculate system JQL names for '" + constantMethod.getName() + "': " + actualMessage), th);
    }

    private static Logger getLogger() {
        return Logger.getLogger(SystemSearchConstants.class);
    }

    static {
        Set<Object> names = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        try {
            for (Method constantMethod : SystemSearchConstants.getConstantMethods()) {
                names.addAll(SystemSearchConstants.getNames(constantMethod));
            }
        }
        catch (RuntimeException e) {
            SystemSearchConstants.getLogger().error((Object)"Unable to calculate system JQL names: Unexpected Error.", (Throwable)e);
            names = Collections.emptySet();
        }
        SYSTEM_NAMES = Collections.unmodifiableSet(names);
        CLAUSE_INFORMATION_MAP = Maps.uniqueIndex((Iterable)ImmutableSet.of((Object)SystemSearchConstants.forAffectedVersion(), (Object)SystemSearchConstants.forAllText(), (Object)SystemSearchConstants.forAssignee(), (Object)SystemSearchConstants.forComments(), (Object)SystemSearchConstants.forComponent(), (Object)SystemSearchConstants.forCreatedDate(), (Object[])new ClauseInformation[]{SystemSearchConstants.forCurrentEstimate(), SystemSearchConstants.forDescription(), SystemSearchConstants.forDueDate(), SystemSearchConstants.forEnvironment(), SystemSearchConstants.forFixForVersion(), SystemSearchConstants.forIssueId(), SystemSearchConstants.forIssueKey(), SystemSearchConstants.forIssueParent(), SystemSearchConstants.forIssueType(), SystemSearchConstants.forLabels(), SystemSearchConstants.forLastViewedDate(), SystemSearchConstants.forOriginalEstimate(), SystemSearchConstants.forPriority(), SystemSearchConstants.forProgress(), SystemSearchConstants.forProject(), SystemSearchConstants.forProjectCategory(), SystemSearchConstants.forReporter(), SystemSearchConstants.forResolution(), SystemSearchConstants.forResolutionDate(), SystemSearchConstants.forSavedFilter(), SystemSearchConstants.forSecurityLevel(), SystemSearchConstants.forStatus(), SystemSearchConstants.forSummary(), SystemSearchConstants.forTimeSpent(), SystemSearchConstants.forUpdatedDate(), SystemSearchConstants.forVoters(), SystemSearchConstants.forVotes(), SystemSearchConstants.forWatchers(), SystemSearchConstants.forWatches(), SystemSearchConstants.forWorkRatio(), SystemSearchConstants.forAttachments()}), (Function)new Function<ClauseInformation, String>(){

            public String apply(ClauseInformation input) {
                return input.getFieldId() != null ? input.getFieldId() : input.getJqlClauseNames().getPrimaryName();
            }
        });
    }
}

