/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.event.AbstractEvent;
import com.atlassian.jira.event.ProjectRelatedEvent;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public abstract class AbstractProjectEvent
extends AbstractEvent
implements ProjectRelatedEvent {
    private final ApplicationUser user;
    private final Project project;

    @Internal
    public AbstractProjectEvent(@Nullable ApplicationUser user, @Nonnull Project project) {
        Preconditions.checkNotNull((Object)project, (Object)"project must not be null");
        this.user = user;
        this.project = project;
    }

    @Override
    @Nonnull
    public Project getProject() {
        return this.project;
    }

    @Nullable
    public ApplicationUser getUser() {
        return this.user;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractProjectEvent event = (AbstractProjectEvent)o;
        if (this.getParams() != null ? !((Object)this.getParams()).equals(event.getParams()) : event.getParams() != null) {
            return false;
        }
        if (this.project != null ? !this.project.equals(event.project) : event.project != null) {
            return false;
        }
        return !(this.user != null ? !((Object)this.user).equals(event.user) : event.user != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.project != null ? this.project.hashCode() : 0);
        result = 29 * result + (this.user != null ? ((Object)this.user).hashCode() : 0);
        return result;
    }
}

