/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.DurationUtils;
import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDateUtils;
import com.google.common.annotations.VisibleForTesting;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class JiraDurationUtils
implements Startable {
    private static final Logger log = Logger.getLogger(JiraDurationUtils.class);
    private final TimeTrackingConfiguration timeTrackingConfiguration;
    private final EventPublisher eventPublisher;
    public static final String FORMAT_PRETTY = "pretty";
    public static final String FORMAT_HOURS = "hours";
    public static final String FORMAT_DAYS = "days";
    private static final String UNIT_DAY = "core.durationutils.unit.day";
    private static final String UNIT_HOUR = "core.durationutils.unit.hour";
    private static final String UNIT_MINUTE = "core.durationutils.unit.minute";
    private static final Map<String, DateUtils.Duration> TOKEN_MAP = new HashMap<String, DateUtils.Duration>();
    protected CachedReference<DurationFormatter> formatterRef;

    public JiraDurationUtils(ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, TimeTrackingConfiguration timeTrackingConfiguration, EventPublisher eventPublisher, I18nHelper.BeanFactory i18nFactory) {
        this(applicationProperties, authenticationContext, timeTrackingConfiguration, eventPublisher, i18nFactory, ComponentAccessor.getComponent(CacheManager.class));
    }

    public JiraDurationUtils(final ApplicationProperties applicationProperties, final JiraAuthenticationContext authenticationContext, final TimeTrackingConfiguration timeTrackingConfiguration, EventPublisher eventPublisher, final I18nHelper.BeanFactory i18nFactory, CacheManager cacheManager) {
        this.timeTrackingConfiguration = timeTrackingConfiguration;
        this.eventPublisher = eventPublisher;
        this.formatterRef = cacheManager.newLazyReferenceBuilder(JiraDateUtils.class, "formatterRef").supplier((Supplier)new Supplier<DurationFormatter>(){

            public DurationFormatter get() {
                BigDecimal hoursPerDay = timeTrackingConfiguration.getHoursPerDay();
                BigDecimal daysPerWeek = timeTrackingConfiguration.getDaysPerWeek();
                String format = applicationProperties.getDefaultBackedString("jira.timetracking.format");
                AuthContextI18nLocator i18nLocator = new AuthContextI18nLocator(i18nFactory, authenticationContext);
                if (JiraDurationUtils.FORMAT_HOURS.equals(format)) {
                    return new HoursDurationFormatter(i18nLocator);
                }
                if (JiraDurationUtils.FORMAT_DAYS.equals(format)) {
                    return new DaysDurationFormatter(hoursPerDay, i18nLocator);
                }
                if (JiraDurationUtils.FORMAT_PRETTY.equals(format)) {
                    return new PrettyDurationFormatter(hoursPerDay, daysPerWeek, i18nLocator);
                }
                log.warn((Object)"Duration format not configured! Please set the jira.timetracking.format property");
                return new PrettyDurationFormatter(hoursPerDay, daysPerWeek, i18nLocator);
            }
        }).build();
    }

    @Override
    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.formatterRef.reset();
    }

    public void updateFormatters(ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext) {
        this.formatterRef.reset();
    }

    public String getI18nKey() {
        return ((DurationFormatter)this.formatterRef.get()).getI18nKey();
    }

    public String getFormattedDuration(Long duration) {
        return ((DurationFormatter)this.formatterRef.get()).format(duration);
    }

    public String getFormattedDuration(Long duration, Locale locale) {
        return ((DurationFormatter)this.formatterRef.get()).format(duration, locale);
    }

    public String getShortFormattedDuration(Long duration) {
        return ((DurationFormatter)this.formatterRef.get()).shortFormat(duration);
    }

    public String getShortFormattedDuration(Long duration, Locale locale) {
        return ((DurationFormatter)this.formatterRef.get()).shortFormat(duration, locale);
    }

    public Long parseDuration(String duration, Locale locale) throws InvalidDurationException {
        BigDecimal hoursPerDay = this.timeTrackingConfiguration.getHoursPerDay();
        BigDecimal daysPerWeek = this.timeTrackingConfiguration.getDaysPerWeek();
        BigDecimal secondsPerHour = BigDecimal.valueOf(DateUtils.Duration.HOUR.getSeconds());
        long secondsPerDay = hoursPerDay.multiply(secondsPerHour).longValueExact();
        long secondsPerWeek = daysPerWeek.multiply(hoursPerDay).multiply(secondsPerHour).longValueExact();
        return DurationUtils.getDurationSeconds((String)duration, (long)secondsPerDay, (long)secondsPerWeek, (DateUtils.Duration)this.timeTrackingConfiguration.getDefaultUnit(), (Locale)locale, TOKEN_MAP);
    }

    public Long parseDuration(String duration) throws InvalidDurationException {
        return this.parseDuration(duration, Locale.UK);
    }

    static TimeFormatWithPrecision calculateFractionalTimeUnit(Long duration, int secondsPerUnit, I18nHelper i18nBean, String unitI18nKey, TimeFormatWithPrecision.Scale scale, Locale userLocale) {
        StringBuilder numberFormatString = new StringBuilder("#");
        String scaleStr = StringUtils.repeat((String)"#", (int)scale.scale);
        if (StringUtils.isNotBlank((String)scaleStr)) {
            numberFormatString.append(".").append(scaleStr);
        }
        String SCALE_STRING = numberFormatString.toString();
        BigDecimal durationBD = BigDecimal.valueOf(duration);
        BigDecimal secondsPerUnitBD = BigDecimal.valueOf(secondsPerUnit);
        DecimalFormat numberFormat = (DecimalFormat)NumberFormat.getNumberInstance(userLocale);
        try {
            Number durationInUnit = scale == TimeFormatWithPrecision.Scale.NO_DECIMALS ? durationBD.divide(secondsPerUnitBD).toBigIntegerExact() : durationBD.setScale(scale.scale, RoundingMode.UNNECESSARY).divide(secondsPerUnitBD).setScale(scale.scale, RoundingMode.UNNECESSARY);
            String format = i18nBean.getText(unitI18nKey, numberFormat.format(durationInUnit));
            return new TimeFormatWithPrecision(format, 0L);
        }
        catch (ArithmeticException e) {
            int integralUnits = (int)(duration.doubleValue() / (double)secondsPerUnit);
            long remainder = duration - (long)(integralUnits * secondsPerUnit);
            String unit = integralUnits == 0 ? "" : i18nBean.getText(unitI18nKey, numberFormat.format(integralUnits));
            return new TimeFormatWithPrecision(unit, remainder);
        }
    }

    static {
        TOKEN_MAP.put("w", DateUtils.Duration.WEEK);
        TOKEN_MAP.put("d", DateUtils.Duration.DAY);
        TOKEN_MAP.put("h", DateUtils.Duration.HOUR);
        TOKEN_MAP.put("m", DateUtils.Duration.MINUTE);
    }

    private static class FixedI18nLocator
    implements I18nLocator {
        private final I18nHelper helper;

        public FixedI18nLocator(I18nHelper helper) {
            this.helper = helper;
        }

        @Override
        public I18nHelper getHelper() {
            return this.helper;
        }

        @Override
        public I18nHelper getHelper(Locale locale) {
            return this.helper;
        }
    }

    private static class AuthContextI18nLocator
    implements I18nLocator {
        private final I18nHelper.BeanFactory factory;
        private final JiraAuthenticationContext authenticationContext;

        private AuthContextI18nLocator(I18nHelper.BeanFactory factory, JiraAuthenticationContext authenticationContext) {
            this.factory = factory;
            this.authenticationContext = authenticationContext;
        }

        @Override
        public I18nHelper getHelper() {
            return this.authenticationContext.getI18nHelper();
        }

        @Override
        public I18nHelper getHelper(Locale locale) {
            return this.factory.getInstance(locale);
        }
    }

    private static interface I18nLocator {
        public I18nHelper getHelper();

        public I18nHelper getHelper(Locale var1);
    }

    private static final class TimeFormatWithPrecision {
        public final String formatted;
        public final long remainder;

        public TimeFormatWithPrecision(String formatted, long remainder) {
            this.formatted = formatted;
            this.remainder = remainder;
        }

        public static enum Scale {
            NO_DECIMALS(0),
            DEFAULT(2);

            public final int scale;

            private Scale(int scale) {
                this.scale = scale;
            }
        }
    }

    public static class DaysDurationFormatter
    implements DurationFormatter {
        public static final String KEY_FORMAT_DAYS = "admin.globalsettings.timetracking.format.days";
        private final BigDecimal hoursPerDay;
        private final I18nLocator locator;

        public DaysDurationFormatter(int hoursPerDay, I18nHelper i18nBean) {
            this(BigDecimal.valueOf(hoursPerDay), i18nBean);
        }

        public DaysDurationFormatter(BigDecimal hoursPerDay, I18nHelper i18nBean) {
            this(hoursPerDay, new FixedI18nLocator(i18nBean));
        }

        private DaysDurationFormatter(BigDecimal hoursPerDay, I18nLocator locator) {
            this.hoursPerDay = hoursPerDay;
            this.locator = locator;
        }

        @Override
        public String getI18nKey() {
            return KEY_FORMAT_DAYS;
        }

        @Override
        public String format(Long duration) {
            return this.format(duration, this.locator.getHelper(), TimeFormatWithPrecision.Scale.DEFAULT);
        }

        @Override
        public String format(Long duration, Locale locale) {
            return this.format(duration, this.locator.getHelper(locale), TimeFormatWithPrecision.Scale.DEFAULT);
        }

        @Override
        public String shortFormat(Long duration) {
            return this.format(duration);
        }

        @Override
        public String shortFormat(Long duration, Locale locale) {
            return this.format(duration, this.locator.getHelper(locale), TimeFormatWithPrecision.Scale.DEFAULT);
        }

        public BigDecimal getHoursPerDay() {
            return this.hoursPerDay;
        }

        private String format(Long duration, I18nHelper i18nBean, TimeFormatWithPrecision.Scale scale) {
            if (duration >= 0L) {
                Locale userLocale = this.locator.getHelper().getLocale();
                TimeFormatWithPrecision result = JiraDurationUtils.calculateFractionalTimeUnit(duration, this.hoursPerDay.multiply(BigDecimal.valueOf(DateUtils.Duration.HOUR.getSeconds())).intValueExact(), i18nBean, JiraDurationUtils.UNIT_DAY, scale, userLocale);
                if (result.remainder == 0L) {
                    return result.formatted;
                }
                if (StringUtils.isEmpty((String)result.formatted)) {
                    return new HoursDurationFormatter(this.locator).format(result.remainder, i18nBean, scale);
                }
                return result.formatted + ' ' + new HoursDurationFormatter(this.locator).format(result.remainder, i18nBean, scale);
            }
            return "";
        }
    }

    public static class HoursDurationFormatter
    implements DurationFormatter {
        public static final String KEY_FORMAT_HOURS = "admin.globalsettings.timetracking.format.hours";
        private final I18nLocator locator;

        public HoursDurationFormatter(I18nHelper i18nBean) {
            this.locator = new FixedI18nLocator(i18nBean);
        }

        private HoursDurationFormatter(I18nLocator locator) {
            this.locator = locator;
        }

        @Override
        public String getI18nKey() {
            return KEY_FORMAT_HOURS;
        }

        @Override
        public String format(Long duration) {
            return this.format(duration, this.locator.getHelper(), TimeFormatWithPrecision.Scale.DEFAULT);
        }

        @Override
        public String format(Long duration, Locale locale) {
            return this.format(duration, this.locator.getHelper(locale), TimeFormatWithPrecision.Scale.DEFAULT);
        }

        @Override
        public String shortFormat(Long duration) {
            return this.format(duration);
        }

        @Override
        public String shortFormat(Long duration, Locale locale) {
            return this.format(duration, locale);
        }

        String format(Long duration, I18nHelper i18nBean, TimeFormatWithPrecision.Scale scale) {
            if (duration >= 0L) {
                Locale userLocale = this.locator.getHelper().getLocale();
                TimeFormatWithPrecision result = JiraDurationUtils.calculateFractionalTimeUnit(duration, (int)DateUtils.Duration.HOUR.getSeconds(), i18nBean, JiraDurationUtils.UNIT_HOUR, scale, userLocale);
                if (result.remainder == 0L) {
                    return result.formatted;
                }
                if (StringUtils.isEmpty((String)result.formatted)) {
                    return JiraDurationUtils.calculateFractionalTimeUnit((Long)Long.valueOf((long)result.remainder), (int)((int)DateUtils.Duration.MINUTE.getSeconds()), (I18nHelper)i18nBean, (String)JiraDurationUtils.UNIT_MINUTE, (TimeFormatWithPrecision.Scale)scale, (Locale)userLocale).formatted;
                }
                return result.formatted + ' ' + JiraDurationUtils.calculateFractionalTimeUnit((Long)Long.valueOf((long)result.remainder), (int)((int)DateUtils.Duration.MINUTE.getSeconds()), (I18nHelper)i18nBean, (String)JiraDurationUtils.UNIT_MINUTE, (TimeFormatWithPrecision.Scale)scale, (Locale)userLocale).formatted;
            }
            return "";
        }
    }

    public static class PrettyDurationFormatter
    implements DurationFormatter {
        public static final String KEY_FORMAT_PRETTY = "admin.globalsettings.timetracking.format.pretty";
        private final BigDecimal hoursPerDay;
        private final BigDecimal daysPerWeek;
        private final I18nLocator locator;

        public PrettyDurationFormatter(int hoursPerDay, int daysPerWeek, I18nHelper i18nBean) {
            this(BigDecimal.valueOf(hoursPerDay), BigDecimal.valueOf(daysPerWeek), i18nBean);
        }

        public PrettyDurationFormatter(BigDecimal hoursPerDay, BigDecimal daysPerWeek, I18nHelper i18nBean) {
            this(hoursPerDay, daysPerWeek, new FixedI18nLocator(i18nBean));
        }

        private PrettyDurationFormatter(BigDecimal hoursPerDay, BigDecimal daysPerWeek, I18nLocator locator) {
            this.hoursPerDay = hoursPerDay;
            this.daysPerWeek = daysPerWeek;
            this.locator = locator;
        }

        @Override
        public String getI18nKey() {
            return KEY_FORMAT_PRETTY;
        }

        @Override
        public String format(Long duration) {
            return this.format(duration, this.locator.getHelper().getDefaultResourceBundle());
        }

        @Override
        public String format(Long duration, Locale locale) {
            return this.format(duration, this.locator.getHelper(locale).getResourceBundle());
        }

        private String format(Long duration, ResourceBundle resourceBundle) {
            BigDecimal secondsPerHour = BigDecimal.valueOf(DateUtils.Duration.HOUR.getSeconds());
            long secondsPerDay = this.hoursPerDay.multiply(secondsPerHour).longValueExact();
            long secondsPerWeek = this.daysPerWeek.multiply(this.hoursPerDay).multiply(secondsPerHour).longValueExact();
            return this.getDurationPrettySeconds(duration, resourceBundle, secondsPerDay, secondsPerWeek);
        }

        @VisibleForTesting
        String getDurationPrettySeconds(Long duration, ResourceBundle resourceBundle, long secondsPerDay, long secondsPerWeek) {
            return DateUtils.getDurationPrettySeconds((long)duration, (long)secondsPerDay, (long)secondsPerWeek, (ResourceBundle)resourceBundle);
        }

        @Override
        public String shortFormat(Long duration) {
            return this.shortFormat(duration, Locale.UK);
        }

        @Override
        public String shortFormat(Long duration, Locale locale) {
            BigDecimal secondsPerHour = BigDecimal.valueOf(DateUtils.Duration.HOUR.getSeconds());
            long secondsPerDay = this.hoursPerDay.multiply(secondsPerHour).longValueExact();
            long secondsPerWeek = this.daysPerWeek.multiply(this.hoursPerDay).multiply(secondsPerHour).longValueExact();
            return DateUtils.getDurationStringSeconds((long)duration, (long)secondsPerDay, (long)secondsPerWeek);
        }

        public BigDecimal getHoursPerDay() {
            return this.hoursPerDay;
        }

        public BigDecimal getDaysPerWeek() {
            return this.daysPerWeek;
        }
    }

    public static interface DurationFormatter {
        public String getI18nKey();

        public String format(Long var1);

        public String format(Long var1, Locale var2);

        public String shortFormat(Long var1);

        public String shortFormat(Long var1, Locale var2);
    }
}

