/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;

public class CollectionEnclosedIterable<T>
implements EnclosedIterable<T> {
    private final Collection<? extends T> collection;

    public static <T> EnclosedIterable<T> from(Collection<? extends T> collection) {
        return new CollectionEnclosedIterable<T>(collection);
    }

    public static <T> EnclosedIterable<T> copy(Collection<? extends T> collection) {
        return new CollectionEnclosedIterable<T>(new ArrayList<T>(collection));
    }

    CollectionEnclosedIterable(@Nonnull Collection<? extends T> collection) {
        this.collection = Assertions.notNull("collection", collection);
    }

    @Override
    public void foreach(Consumer<T> sink) {
        for (T element : this.collection) {
            sink.consume(element);
        }
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        CollectionEnclosedIterable other = (CollectionEnclosedIterable)obj;
        return ((Object)this.collection).equals(other.collection);
    }

    public int hashCode() {
        return ((Object)this.collection).hashCode();
    }
}

