/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.permission.PermissionType;
import java.util.Locale;
import javax.annotation.Nullable;

public enum Permission {
    ADMINISTER(0, PermissionType.GLOBAL, "admin.global.permissions.administer", "admin.permissions.descriptions.ADMINISTER"),
    USE(1, PermissionType.GLOBAL, "admin.global.permissions.use", "admin.permissions.descriptions.USE"),
    SYSTEM_ADMIN(44, PermissionType.GLOBAL, "admin.global.permissions.system.administer", "admin.permissions.descriptions.SYS_ADMIN"),
    CREATE_SHARED_OBJECTS(22, PermissionType.GLOBAL, "admin.global.permissions.create.shared.filter", "admin.permissions.descriptions.CREATE_SHARED_OBJECTS"),
    MANAGE_GROUP_FILTER_SUBSCRIPTIONS(24, PermissionType.GLOBAL, "admin.global.permissions.manage.group.filter.subscriptions", "admin.permissions.descriptions.MANAGE_GROUP_FILTER_SUBSCRIPTIONS"),
    BULK_CHANGE(33, PermissionType.GLOBAL, "admin.global.permissions.bulk.change", "admin.permissions.descriptions.BULK_CHANGE"),
    USER_PICKER(27, PermissionType.GLOBAL, "admin.global.permissions.user.picker", "admin.permissions.descriptions.USER_PICKER"),
    PROJECT_ADMIN(23, PermissionType.PROJECT, "admin.permissions.PROJECT_ADMIN", "admin.permissions.descriptions.PROJECT_ADMIN"),
    BROWSE(10, PermissionType.PROJECT, "admin.permissions.BROWSE", "admin.permissions.descriptions.BROWSE"),
    VIEW_VERSION_CONTROL(29, PermissionType.PROJECT, "admin.permissions.VIEW_VERSION_CONTROL", "admin.permissions.descriptions.VIEW_VERSION_CONTROL"),
    VIEW_WORKFLOW_READONLY(45, PermissionType.PROJECT, "admin.permissions.VIEW_WORKFLOW_READONLY", "admin.permissions.descriptions.WORKFLOW_VIEW_READONLY"),
    CREATE_ISSUE(11, PermissionType.ISSUE, "admin.permissions.CREATE_ISSUE", "admin.permissions.descriptions.CREATE_ISSUE"),
    EDIT_ISSUE(12, PermissionType.ISSUE, "admin.permissions.EDIT_ISSUE", "admin.permissions.descriptions.EDIT_ISSUE"),
    ASSIGN_ISSUE(13, PermissionType.ISSUE, "admin.permissions.ASSIGN_ISSUE", "admin.permissions.descriptions.ASSIGN_ISSUE"),
    RESOLVE_ISSUE(14, PermissionType.ISSUE, "admin.permissions.RESOLVE_ISSUE", "admin.permissions.descriptions.RESOLVE_ISSUE"),
    DELETE_ISSUE(16, PermissionType.ISSUE, "admin.permissions.DELETE_ISSUE", "admin.permissions.descriptions.DELETE_ISSUE"),
    ASSIGNABLE_USER(17, PermissionType.ISSUE, "admin.permissions.ASSIGNABLE_USER", "admin.permissions.descriptions.ASSIGNABLE_USER"),
    CLOSE_ISSUE(18, PermissionType.ISSUE, "admin.permissions.CLOSE_ISSUE", "admin.permissions.descriptions.CLOSE_ISSUE"),
    LINK_ISSUE(21, PermissionType.ISSUE, "admin.permissions.LINK_ISSUE", "admin.permissions.descriptions.LINK_ISSUE"),
    MOVE_ISSUE(25, PermissionType.ISSUE, "admin.permissions.MOVE_ISSUE", "admin.permissions.descriptions.MOVE_ISSUE"),
    SET_ISSUE_SECURITY(26, PermissionType.ISSUE, "admin.permissions.SET_ISSUE_SECURITY", "admin.permissions.descriptions.SET_ISSUE_SECURITY"),
    SCHEDULE_ISSUE(28, PermissionType.ISSUE, "admin.permissions.SCHEDULE_ISSUE", "admin.permissions.descriptions.SCHEDULE_ISSUE"),
    MODIFY_REPORTER(30, PermissionType.ISSUE, "admin.permissions.MODIFY_REPORTER", "admin.permissions.descriptions.MODIFY_REPORTER"),
    VIEW_VOTERS_AND_WATCHERS(31, PermissionType.VOTERS_AND_WATCHERS, "admin.permissions.VIEW_VOTERS_AND_WATCHERS", "admin.permissions.descriptions.VIEW_VOTERS_AND_WATCHERS"),
    MANAGE_WATCHER_LIST(32, PermissionType.VOTERS_AND_WATCHERS, "admin.permissions.MANAGE_WATCHER_LIST", "admin.permissions.descriptions.MANAGE_WATCHER_LIST"),
    COMMENT_ISSUE(15, PermissionType.COMMENTS, "admin.permissions.COMMENT_ISSUE", "admin.permissions.descriptions.COMMENT_ISSUE"),
    COMMENT_EDIT_ALL(34, PermissionType.COMMENTS, "admin.permissions.COMMENT_EDIT_ALL", "admin.permissions.descriptions.COMMENT_EDIT_ALL"),
    COMMENT_EDIT_OWN(35, PermissionType.COMMENTS, "admin.permissions.COMMENT_EDIT_OWN", "admin.permissions.descriptions.COMMENT_EDIT_OWN"),
    COMMENT_DELETE_ALL(36, PermissionType.COMMENTS, "admin.permissions.COMMENT_DELETE_ALL", "admin.permissions.descriptions.COMMENT_DELETE_ALL"),
    COMMENT_DELETE_OWN(37, PermissionType.COMMENTS, "admin.permissions.COMMENT_DELETE_OWN", "admin.permissions.descriptions.COMMENT_DELETE_OWN"),
    CREATE_ATTACHMENT(19, PermissionType.ATTACHMENTS, "admin.permissions.CREATE_ATTACHMENT", "admin.permissions.descriptions.CREATE_ATTACHMENT"),
    ATTACHMENT_DELETE_ALL(38, PermissionType.ATTACHMENTS, "admin.permissions.ATTACHMENT_DELETE_ALL", "admin.permissions.descriptions.ATTACHMENT_DELETE_ALL"),
    ATTACHMENT_DELETE_OWN(39, PermissionType.ATTACHMENTS, "admin.permissions.ATTACHMENT_DELETE_OWN", "admin.permissions.descriptions.ATTACHMENT_DELETE_OWN"),
    WORK_ISSUE(20, PermissionType.TIME_TRACKING, "admin.permissions.WORK_ISSUE", "admin.permissions.descriptions.WORK_ISSUE"),
    WORKLOG_EDIT_OWN(40, PermissionType.TIME_TRACKING, "admin.permissions.WORKLOG_EDIT_OWN", "admin.permissions.descriptions.WORKLOG_EDIT_OWN"),
    WORKLOG_EDIT_ALL(41, PermissionType.TIME_TRACKING, "admin.permissions.WORKLOG_EDIT_ALL", "admin.permissions.descriptions.WORKLOG_EDIT_ALL"),
    WORKLOG_DELETE_OWN(42, PermissionType.TIME_TRACKING, "admin.permissions.WORKLOG_DELETE_OWN", "admin.permissions.descriptions.WORKLOG_DELETE_OWN"),
    WORKLOG_DELETE_ALL(43, PermissionType.TIME_TRACKING, "admin.permissions.WORKLOG_DELETE_ALL", "admin.permissions.descriptions.WORKLOG_DELETE_ALL");

    private int id;
    private PermissionType type;
    private String nameKey;
    private String descriptionKey;

    private Permission(int id, PermissionType type, String nameKey, String descriptionKey) {
        this.id = id;
        this.type = type;
        this.nameKey = nameKey;
        this.descriptionKey = descriptionKey;
    }

    public int getId() {
        return this.id;
    }

    public PermissionType getType() {
        return this.type;
    }

    public String getName() {
        return ComponentAccessor.getI18nHelperFactory().getInstance(Locale.ENGLISH).getText(this.getNameKey());
    }

    public String getNameKey() {
        return this.nameKey;
    }

    public String getDescription() {
        return ComponentAccessor.getJiraAuthenticationContext().getI18nHelper().getText(this.getDescriptionKey());
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public static Permission valueOf(int permissionId) throws IllegalArgumentException {
        Permission permission = Permission.getPermissionById(permissionId);
        if (permission != null) {
            return permission;
        }
        throw new IllegalArgumentException(Integer.toString(permissionId));
    }

    @Nullable
    public static Permission getPermissionById(int permissionId) {
        for (Permission permission : Permission.values()) {
            if (permission.getId() != permissionId) continue;
            return permission;
        }
        return null;
    }
}

