/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMElement;

@ExperimentalApi
public class IndexDocumentConfiguration {
    public static final String INDEX_DOCUMENT_CONFIGURATION_ROOT = "index-document-configuration";
    public static final String INDEX_DOCUMENT_KEY_ELEMENT = "key";
    public static final String INDEX_DOCUMENT_ENTITY_KEY_ATTRIBUTE = "entity-key";
    public static final String INDEX_DOCUMENT_KEY_PROPERTY_KEY_ATTRIBUTE = "property-key";
    public static final String INDEX_DOCUMENT_EXTRACT_ELEMENT = "extract";
    public static final String INDEX_DOCUMENT_EXTRACT_PATH_ATTRIBUTE = "path";
    public static final String INDEX_DOCUMENT_EXTRACT_TYPE_ATTRIBUTE = "type";
    private final String entityKey;
    private final List<KeyConfiguration> keyConfigurations;

    public IndexDocumentConfiguration(String entityKey, List<KeyConfiguration> keyConfigurations) {
        this.entityKey = entityKey;
        this.keyConfigurations = ImmutableList.copyOf(keyConfigurations);
    }

    public static IndexDocumentConfiguration fromXML(String element) throws IndexDocumentConfigurationParseException {
        try {
            return IndexDocumentConfiguration.fromXML(DocumentHelper.parseText((String)element).getRootElement());
        }
        catch (DocumentException e) {
            throw new IndexDocumentConfigurationParseException("Cannot parse document ", e);
        }
    }

    public static IndexDocumentConfiguration fromXML(Element element) throws IndexDocumentConfigurationParseException {
        if (!INDEX_DOCUMENT_CONFIGURATION_ROOT.equals(element.getName())) {
            throw new IndexDocumentConfigurationParseException(MessageFormat.format("Root element for configuration should be {0}", INDEX_DOCUMENT_CONFIGURATION_ROOT));
        }
        String entityKey = IndexDocumentConfiguration.getRequiredAttribute(element, INDEX_DOCUMENT_CONFIGURATION_ROOT, INDEX_DOCUMENT_ENTITY_KEY_ATTRIBUTE);
        return new IndexDocumentConfiguration(entityKey, IndexDocumentConfiguration.transformRequiredElements(element, INDEX_DOCUMENT_KEY_ELEMENT, new Function<Element, Either<KeyConfiguration, IndexDocumentConfigurationParseException>>(){

            public Either<KeyConfiguration, IndexDocumentConfigurationParseException> apply(Element input) {
                return KeyConfiguration.fromXml(input);
            }
        }));
    }

    private static <T> List<T> transformRequiredElements(Element element, String elementName, Function<Element, Either<T, IndexDocumentConfigurationParseException>> function) throws IndexDocumentConfigurationParseException {
        List childElements = element.elements(elementName);
        if (childElements.size() < 1) {
            throw new IndexDocumentConfigurationParseException(MessageFormat.format("Expected at least one {0} element", elementName));
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (Element childElement : childElements) {
            Either output = (Either)function.apply((Object)childElement);
            if (output.isLeft()) {
                listBuilder.add(output.left().get());
                continue;
            }
            throw (IndexDocumentConfigurationParseException)output.right().get();
        }
        return listBuilder.build();
    }

    private static String getRequiredAttribute(Element element, String elementName, String attributeName) throws IndexDocumentConfigurationParseException {
        Attribute entityKeyAttribute = element.attribute(attributeName);
        if (entityKeyAttribute == null) {
            throw new IndexDocumentConfigurationParseException(MessageFormat.format("Element {0} must have attribute {1} deffined", elementName, attributeName));
        }
        return entityKeyAttribute.getValue();
    }

    public List<KeyConfiguration> getKeyConfigurations() {
        return this.keyConfigurations;
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public String toXML() {
        DOMDocument document = new DOMDocument();
        DOMElement configurationElement = new DOMElement(INDEX_DOCUMENT_CONFIGURATION_ROOT);
        configurationElement.add((Attribute)new DOMAttribute(QName.get((String)INDEX_DOCUMENT_ENTITY_KEY_ATTRIBUTE), this.getEntityKey()));
        document.setRootElement((Element)configurationElement);
        for (KeyConfiguration keyConfiguration : this.keyConfigurations) {
            DOMElement keyConfigurationElement = new DOMElement(INDEX_DOCUMENT_KEY_ELEMENT);
            keyConfigurationElement.add((Attribute)new DOMAttribute(QName.get((String)INDEX_DOCUMENT_KEY_PROPERTY_KEY_ATTRIBUTE), keyConfiguration.getPropertyKey()));
            for (ExtractConfiguration extractConfiguration : keyConfiguration.getExtractorConfigurations()) {
                DOMElement extractConfigurationElement = new DOMElement(INDEX_DOCUMENT_EXTRACT_ELEMENT);
                extractConfigurationElement.add((Attribute)new DOMAttribute(QName.get((String)INDEX_DOCUMENT_EXTRACT_PATH_ATTRIBUTE), extractConfiguration.getPath()));
                extractConfigurationElement.add((Attribute)new DOMAttribute(QName.get((String)INDEX_DOCUMENT_EXTRACT_TYPE_ATTRIBUTE), extractConfiguration.getType().name()));
                keyConfigurationElement.add((Element)extractConfigurationElement);
            }
            configurationElement.add((Element)keyConfigurationElement);
        }
        return document.asXML();
    }

    public static class IndexDocumentConfigurationParseException
    extends Exception {
        private IndexDocumentConfigurationParseException(String message) {
            super(message);
        }

        public IndexDocumentConfigurationParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @ExperimentalApi
    public static class ExtractConfiguration {
        private final String path;
        private final Type type;

        public ExtractConfiguration(String path, Type type) {
            this.path = path;
            this.type = type;
        }

        public static Either<ExtractConfiguration, IndexDocumentConfigurationParseException> fromXml(Element extractElement) {
            assert (IndexDocumentConfiguration.INDEX_DOCUMENT_EXTRACT_ELEMENT.equals(extractElement.getName())) : "Unexpected name for element " + extractElement.getName();
            try {
                String path = IndexDocumentConfiguration.getRequiredAttribute(extractElement, IndexDocumentConfiguration.INDEX_DOCUMENT_EXTRACT_ELEMENT, IndexDocumentConfiguration.INDEX_DOCUMENT_EXTRACT_PATH_ATTRIBUTE);
                String typeStr = IndexDocumentConfiguration.getRequiredAttribute(extractElement, IndexDocumentConfiguration.INDEX_DOCUMENT_EXTRACT_ELEMENT, IndexDocumentConfiguration.INDEX_DOCUMENT_EXTRACT_TYPE_ATTRIBUTE);
                Option<Type> type = Type.getValue(typeStr);
                if (type.isEmpty()) {
                    return Either.right((Object)new IndexDocumentConfigurationParseException(MessageFormat.format("Illegal value {0} for type argument expected one of {1}", typeStr, Arrays.toString((Object[])Type.values()))));
                }
                return Either.left((Object)new ExtractConfiguration(path, (Type)((Object)type.get())));
            }
            catch (IndexDocumentConfigurationParseException e) {
                return Either.right((Object)e);
            }
        }

        public String getPath() {
            return this.path;
        }

        public Type getType() {
            return this.type;
        }
    }

    @ExperimentalApi
    public static class KeyConfiguration {
        private final List<ExtractConfiguration> extractorConfigurations;
        private final String propertyKey;

        public KeyConfiguration(String propertyKey, List<ExtractConfiguration> extractorConfigurations) {
            this.propertyKey = propertyKey;
            this.extractorConfigurations = ImmutableList.copyOf(extractorConfigurations);
        }

        private static Either<KeyConfiguration, IndexDocumentConfigurationParseException> fromXml(Element keyElement) {
            assert (IndexDocumentConfiguration.INDEX_DOCUMENT_KEY_ELEMENT.equals(keyElement.getName())) : "Unexpected name for element " + keyElement.getName();
            try {
                String propertyKey = IndexDocumentConfiguration.getRequiredAttribute(keyElement, IndexDocumentConfiguration.INDEX_DOCUMENT_KEY_ELEMENT, IndexDocumentConfiguration.INDEX_DOCUMENT_KEY_PROPERTY_KEY_ATTRIBUTE);
                return Either.left((Object)new KeyConfiguration(propertyKey, IndexDocumentConfiguration.transformRequiredElements(keyElement, IndexDocumentConfiguration.INDEX_DOCUMENT_EXTRACT_ELEMENT, (Function)new Function<Element, Either<ExtractConfiguration, IndexDocumentConfigurationParseException>>(){

                    public Either<ExtractConfiguration, IndexDocumentConfigurationParseException> apply(Element input) {
                        return ExtractConfiguration.fromXml(input);
                    }
                })));
            }
            catch (IndexDocumentConfigurationParseException e) {
                return Either.right((Object)e);
            }
        }

        public List<ExtractConfiguration> getExtractorConfigurations() {
            return this.extractorConfigurations;
        }

        public String getPropertyKey() {
            return this.propertyKey;
        }
    }

    @ExperimentalApi
    public static enum Type {
        NUMBER,
        TEXT,
        STRING,
        DATE;


        public static Option<Type> getValue(String value) {
            try {
                Type type = Type.valueOf(StringUtils.upperCase((String)value));
                return Option.some((Object)((Object)type));
            }
            catch (IllegalArgumentException ignore) {
                return Option.none();
            }
        }
    }
}

