/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.version;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericValue;

@PublicApi
public interface VersionManager {
    public static final String NO_VERSIONS = "-1";
    public static final String ALL_UNRELEASED_VERSIONS = "-2";
    public static final String ALL_RELEASED_VERSIONS = "-3";

    public Version createVersion(String var1, Date var2, String var3, Long var4, Long var5) throws CreateException;

    public Version createVersion(String var1, Date var2, Date var3, String var4, Long var5, Long var6) throws CreateException;

    public void moveToStartVersionSequence(Version var1);

    public void increaseVersionSequence(Version var1);

    public void decreaseVersionSequence(Version var1);

    public void moveToEndVersionSequence(Version var1);

    public void moveVersionAfter(Version var1, Long var2);

    public void deleteVersion(Version var1);

    @Deprecated
    public void editVersionDetails(Version var1, String var2, String var3, GenericValue var4);

    public void editVersionDetails(Version var1, String var2, String var3);

    public boolean isDuplicateName(Version var1, String var2);

    @Deprecated
    public boolean isDuplicateName(Version var1, String var2, GenericValue var3);

    public void releaseVersion(Version var1, boolean var2);

    public void releaseVersions(Collection<Version> var1, boolean var2);

    public void moveIssuesToNewVersion(List<GenericValue> var1, Version var2, Version var3) throws IndexException;

    public void archiveVersions(String[] var1, String[] var2);

    public void archiveVersion(Version var1, boolean var2);

    public Collection<Version> getVersionsUnarchived(Long var1);

    public Collection<Version> getVersionsArchived(GenericValue var1);

    public Collection<Version> getVersionsArchived(Project var1);

    public Version update(Version var1);

    public void editVersionReleaseDate(Version var1, Date var2);

    public void editVersionStartDate(Version var1, Date var2);

    public void editVersionStartReleaseDate(Version var1, Date var2, Date var3);

    public boolean isVersionOverDue(Version var1);

    public List<Version> getVersions(GenericValue var1);

    public List<Version> getVersions(Long var1);

    public List<Version> getVersions(Long var1, boolean var2);

    public List<Version> getVersions(Project var1);

    public Collection<Version> getVersionsByName(String var1);

    public Collection<Version> getVersions(List<Long> var1);

    public Version getVersion(Long var1);

    public Version getVersion(Long var1, String var2);

    public Collection<Version> getVersionsUnreleased(Long var1, boolean var2);

    public Collection<Version> getVersionsReleased(Long var1, boolean var2);

    public Collection<Version> getVersionsReleasedDesc(Long var1, boolean var2);

    public Collection<Version> getOtherVersions(Version var1);

    public Collection<Version> getOtherUnarchivedVersions(Version var1);

    @Deprecated
    public Collection<GenericValue> getAllAffectedIssues(Collection<Version> var1);

    @Deprecated
    public Collection<GenericValue> getFixIssues(Version var1);

    public Collection<Issue> getIssuesWithFixVersion(Version var1);

    @Deprecated
    public Collection<GenericValue> getAffectsIssues(Version var1);

    public Collection<Issue> getIssuesWithAffectsVersion(Version var1);

    public Collection<Long> getIssueIdsWithAffectsVersion(@Nonnull Version var1);

    public Collection<Long> getIssueIdsWithFixVersion(@Nonnull Version var1);

    @Deprecated
    public Collection<Version> getAffectedVersionsByIssue(GenericValue var1);

    public Collection<Version> getAffectedVersionsFor(Issue var1);

    @Deprecated
    public Collection<Version> getFixVersionsByIssue(GenericValue var1);

    public Collection<Version> getFixVersionsFor(Issue var1);

    public Collection<Version> getAllVersions();

    public Collection<Version> getAllVersionsForProjects(Collection<Project> var1, boolean var2);

    public Collection<Version> getAllVersionsReleased(boolean var1);

    public Collection<Version> getAllVersionsUnreleased(boolean var1);
}

