/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.BridgedDirectoryUser;
import com.atlassian.jira.util.dbc.Assertions;

public class DelegatingApplicationUser
implements ApplicationUser {
    private final String key;
    private final User user;
    private final User bridgedUser;

    public DelegatingApplicationUser(String key, User user) {
        this.key = Assertions.notNull("key", key);
        this.user = Assertions.notNull("user", user);
        this.bridgedUser = new BridgedDirectoryUser(user, this);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public boolean isActive() {
        return this.user.isActive();
    }

    @Override
    public String getEmailAddress() {
        return this.user.getEmailAddress();
    }

    @Override
    public String getDisplayName() {
        return this.user.getDisplayName();
    }

    @Override
    public User getDirectoryUser() {
        return this.bridgedUser;
    }

    @Override
    public String getUsername() {
        return this.user.getName();
    }

    @Override
    public String getName() {
        return this.user.getName();
    }

    @Override
    public long getDirectoryId() {
        return this.user.getDirectoryId();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ApplicationUser) {
            ApplicationUser other = (ApplicationUser)obj;
            return this.key.equals(other.getKey());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public String toString() {
        return this.getUsername() + '(' + this.getKey() + ')';
    }
}

