/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.issue.statistics.util.LongComparator;
import java.util.Comparator;

public class LongFieldStatisticsMapper
implements StatisticsMapper {
    public static final StatisticsMapper WORK_RATIO = new LongFieldStatisticsMapper("workratio");
    public static final StatisticsMapper PROGRESS = new LongFieldStatisticsMapper("progress");
    private final String documentConstant;

    public LongFieldStatisticsMapper(String documentConstant) {
        this.documentConstant = documentConstant;
    }

    @Override
    public String getDocumentConstant() {
        return this.documentConstant;
    }

    @Override
    public Object getValueFromLuceneField(String documentValue) {
        if ("-1".equals(documentValue)) {
            return null;
        }
        return new Long(documentValue);
    }

    @Override
    public Comparator getComparator() {
        return LongComparator.COMPARATOR;
    }

    public boolean isValidValue(Object value) {
        return true;
    }

    @Override
    public boolean isFieldAlwaysPartOfAnIssue() {
        return true;
    }

    public SearchRequest getSearchUrlSuffix(Object value, SearchRequest searchRequest) {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongFieldStatisticsMapper)) {
            return false;
        }
        LongFieldStatisticsMapper that = (LongFieldStatisticsMapper)o;
        return !(this.documentConstant != null ? !this.documentConstant.equals(that.documentConstant) : that.documentConstant != null);
    }

    @Override
    public int hashCode() {
        return this.getDocumentConstant() != null ? this.getDocumentConstant().hashCode() : 0;
    }
}

