/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicSpi
public abstract class AbstractMultiCFType<S>
extends AbstractCustomFieldType<Collection<S>, S> {
    protected final CustomFieldValuePersister customFieldValuePersister;
    protected final GenericConfigManager genericConfigManager;

    protected AbstractMultiCFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager) {
        this.genericConfigManager = genericConfigManager;
        this.customFieldValuePersister = customFieldValuePersister;
    }

    @Nullable
    protected abstract Comparator<S> getTypeComparator();

    @Nullable
    protected abstract Object convertTypeToDbValue(@Nullable S var1);

    @Nullable
    protected abstract S convertDbValueToType(@Nullable Object var1);

    @Nonnull
    protected abstract PersistenceFieldType getDatabaseType();

    @Override
    public Collection<S> getDefaultValue(FieldConfig fieldConfig) {
        Object o = this.genericConfigManager.retrieve("DefaultValue", fieldConfig.getId().toString());
        if (o == null) {
            return null;
        }
        if (o instanceof Collection) {
            return this.convertDbObjectToTypes((Collection)o);
        }
        throw new IllegalArgumentException("Value: " + o + " must be a collection. Type not allowed: " + o.getClass());
    }

    @Override
    public void setDefaultValue(FieldConfig fieldConfig, Collection<S> value) {
        Collection<Object> names = this.convertTypesToDbObjects(value);
        if (names == null || names.isEmpty()) {
            this.genericConfigManager.update("DefaultValue", fieldConfig.getId().toString(), null);
        } else {
            this.genericConfigManager.update("DefaultValue", fieldConfig.getId().toString(), names);
        }
    }

    @Override
    public void createValue(CustomField customField, Issue issue, Collection<S> value) {
        this.customFieldValuePersister.createValues(customField, issue.getId(), this.getDatabaseType(), this.convertTypesToDbObjects(value));
    }

    @Override
    public void updateValue(CustomField customField, Issue issue, Collection<S> value) {
        this.customFieldValuePersister.updateValues(customField, issue.getId(), this.getDatabaseType(), this.convertTypesToDbObjects(value));
    }

    @Override
    public Collection<S> getValueFromIssue(CustomField field, Issue issue) {
        List<Object> textValues = this.customFieldValuePersister.getValues(field, issue.getId(), this.getDatabaseType());
        return textValues == null || textValues.isEmpty() ? null : this.convertDbObjectToTypes(textValues);
    }

    @Override
    public String getChangelogValue(CustomField field, Collection<S> values) {
        if (values == null || values.isEmpty()) {
            return "";
        }
        ArrayList<String> changeLogValues = new ArrayList<String>(values.size());
        for (S singleValue : values) {
            changeLogValues.add(this.getStringFromSingularObject(singleValue));
        }
        return changeLogValues.toString();
    }

    protected final Collection<Object> convertTypesToDbObjects(Collection<S> typedList) {
        if (typedList == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> dbObjects = new ArrayList<Object>();
        for (S item : typedList) {
            Object dbObject = this.convertTypeToDbValue(item);
            if (dbObject == null) continue;
            dbObjects.add(dbObject);
        }
        return dbObjects;
    }

    protected final Collection<S> convertDbObjectToTypes(Collection<Object> dbObjects) {
        if (dbObjects == null) {
            return null;
        }
        HashSet<S> retSet = new HashSet<S>();
        for (Object element : dbObjects) {
            try {
                S value = this.convertDbValueToType(element);
                if (value == null) continue;
                retSet.add(value);
            }
            catch (FieldValidationException ignore) {}
        }
        ArrayList list = new ArrayList(retSet);
        Comparator<S> typeComparator = this.getTypeComparator();
        if (typeComparator != null) {
            Collections.sort(list, typeComparator);
        }
        return list;
    }

    @Override
    public Set<Long> remove(CustomField field) {
        return this.customFieldValuePersister.removeAllValues(field.getId());
    }

    @Override
    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitMultiField(this);
        }
        return super.accept(visitor);
    }

    public static interface Visitor<X>
    extends AbstractCustomFieldType.VisitorBase<X> {
        public X visitMultiField(AbstractMultiCFType var1);
    }
}

