/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.List;
import javax.annotation.Nullable;

@PublicApi
public interface ProjectService {
    public static final String PROJECT_NAME = "projectName";
    public static final String PROJECT_KEY = "projectKey";
    public static final String PROJECT_LEAD = "projectLead";
    public static final String PROJECT_URL = "projectUrl";
    public static final String PROJECT_DESCRIPTION = "projectDescription";
    public static final int MAX_NAME_LENGTH = 80;
    public static final int MIN_NAME_LENGTH = 2;
    public static final int MAX_KEY_LENGTH = 10;
    public static final int DEFAULT_NAME_LENGTH = 80;

    public CreateProjectValidationResult validateCreateProject(User var1, String var2, String var3, String var4, String var5, String var6, @Nullable Long var7);

    public CreateProjectValidationResult validateCreateProject(User var1, String var2, String var3, String var4, String var5, String var6, @Nullable Long var7, Long var8);

    public Project createProject(CreateProjectValidationResult var1);

    public ServiceResult validateUpdateProject(User var1, String var2);

    public ServiceResult validateUpdateProject(ApplicationUser var1, String var2);

    public UpdateProjectValidationResult validateUpdateProject(User var1, String var2, String var3, String var4, String var5, String var6, Long var7);

    public UpdateProjectValidationResult validateUpdateProject(ApplicationUser var1, String var2, String var3, String var4, ApplicationUser var5, String var6, Long var7);

    public UpdateProjectValidationResult validateUpdateProject(ApplicationUser var1, Project var2, String var3, String var4, String var5, ApplicationUser var6, String var7, Long var8, Long var9);

    public UpdateProjectValidationResult validateUpdateProject(User var1, String var2, String var3, String var4, String var5, String var6, Long var7, Long var8);

    public UpdateProjectValidationResult validateUpdateProject(ApplicationUser var1, String var2, String var3, String var4, ApplicationUser var5, String var6, Long var7, Long var8);

    public Project updateProject(UpdateProjectValidationResult var1);

    public DeleteProjectValidationResult validateDeleteProject(User var1, String var2);

    public DeleteProjectValidationResult validateDeleteProject(ApplicationUser var1, String var2);

    public DeleteProjectResult deleteProject(User var1, DeleteProjectValidationResult var2);

    public DeleteProjectResult deleteProject(ApplicationUser var1, DeleteProjectValidationResult var2);

    public UpdateProjectSchemesValidationResult validateUpdateProjectSchemes(User var1, Long var2, Long var3, Long var4);

    public UpdateProjectSchemesValidationResult validateUpdateProjectSchemes(ApplicationUser var1, Long var2, Long var3, Long var4);

    public void updateProjectSchemes(UpdateProjectSchemesValidationResult var1, Project var2);

    public boolean isValidAllProjectData(JiraServiceContext var1, String var2, String var3, String var4, String var5, Long var6);

    public boolean isValidAllProjectData(JiraServiceContext var1, String var2, String var3, String var4, String var5, Long var6, Long var7);

    public boolean isValidRequiredProjectData(JiraServiceContext var1, String var2, String var3, String var4);

    public boolean isValidProjectKey(JiraServiceContext var1, String var2);

    public String getProjectKeyDescription();

    public GetProjectResult getProjectById(User var1, Long var2);

    public GetProjectResult getProjectById(ApplicationUser var1, Long var2);

    public GetProjectResult getProjectByIdForAction(User var1, Long var2, ProjectAction var3);

    public GetProjectResult getProjectByIdForAction(ApplicationUser var1, Long var2, ProjectAction var3);

    public GetProjectResult getProjectByKey(User var1, String var2);

    public GetProjectResult getProjectByKey(ApplicationUser var1, String var2);

    public GetProjectResult getProjectByKeyForAction(User var1, String var2, ProjectAction var3);

    public int getMaximumNameLength();

    public GetProjectResult getProjectByKeyForAction(ApplicationUser var1, String var2, ProjectAction var3);

    public int getMaximumKeyLength();

    public long getProjectCount();

    public ServiceOutcome<List<Project>> getAllProjects(User var1);

    public ServiceOutcome<List<Project>> getAllProjects(ApplicationUser var1);

    public ServiceOutcome<List<Project>> getAllProjectsForAction(User var1, ProjectAction var2);

    public ServiceOutcome<List<Project>> getAllProjectsForAction(ApplicationUser var1, ProjectAction var2);

    @PublicApi
    public static class DeleteProjectResult
    extends ServiceResultImpl {
        public DeleteProjectResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }
    }

    @PublicApi
    public static class DeleteProjectValidationResult
    extends AbstractProjectResult {
        public DeleteProjectValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }

        public DeleteProjectValidationResult(ErrorCollection errorCollection, Project project) {
            super(errorCollection, project);
        }
    }

    @Internal
    public static class CreateProjectResult
    extends AbstractProjectResult {
        public CreateProjectResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }

        public CreateProjectResult(ErrorCollection errorCollection, Project project) {
            super(errorCollection, project);
        }
    }

    @PublicApi
    public static class GetProjectResult
    extends AbstractProjectResult {
        public GetProjectResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }

        public GetProjectResult(Project project) {
            super(new SimpleErrorCollection(), project);
        }

        public GetProjectResult(ErrorCollection errorCollection, Project project) {
            super(errorCollection, project);
        }
    }

    @PublicApi
    public static abstract class AbstractProjectResult
    extends ServiceResultImpl {
        private Project project;

        public AbstractProjectResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }

        public AbstractProjectResult(ErrorCollection errorCollection, Project project) {
            super(errorCollection);
            this.project = project;
        }

        public Project getProject() {
            return this.project;
        }
    }

    @PublicApi
    public static class UpdateProjectValidationResult
    extends AbstractProjectValidationResult {
        private final Project originalProject;

        public UpdateProjectValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
            this.originalProject = null;
        }

        public UpdateProjectValidationResult(ErrorCollection errorCollection, String name, String key, String description, String lead, String url, Long assigneeType, Long avatarId, Project originalProject, boolean keyChanged) {
            super(errorCollection, name, key, description, lead, url, assigneeType, avatarId, keyChanged);
            this.originalProject = originalProject;
        }

        public Project getOriginalProject() {
            return this.originalProject;
        }
    }

    @PublicApi
    public static class CreateProjectValidationResult
    extends AbstractProjectValidationResult {
        public CreateProjectValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }

        public CreateProjectValidationResult(ErrorCollection errorCollection, String name, String key, String description, String lead, String url, Long assigneeType, Long avatarId) {
            super(errorCollection, name, key, description, lead, url, assigneeType, avatarId, false);
        }

        public CreateProjectValidationResult(ErrorCollection errorCollection, String name, String key, String description, String lead, String url, Long assigneeType, Long avatarId, boolean keyChanged) {
            super(errorCollection, name, key, description, lead, url, assigneeType, avatarId, keyChanged);
        }
    }

    @PublicApi
    public static abstract class AbstractProjectValidationResult
    extends ServiceResultImpl {
        private final String name;
        private final String key;
        private final String description;
        private final String leadName;
        private final String url;
        private final Long assigneeType;
        private final Long avatarId;
        private final boolean keyChanged;

        public AbstractProjectValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
            this.name = null;
            this.key = null;
            this.description = null;
            this.leadName = null;
            this.url = null;
            this.assigneeType = null;
            this.avatarId = null;
            this.keyChanged = false;
        }

        public AbstractProjectValidationResult(ErrorCollection errorCollection, String name, String key, String description, String leadName, String url, Long assigneeType, Long avatarId, boolean keyChanged) {
            super(errorCollection);
            this.name = name;
            this.key = key;
            this.description = description;
            this.leadName = leadName;
            this.url = url;
            this.assigneeType = assigneeType;
            this.avatarId = avatarId;
            this.keyChanged = keyChanged;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLeadUsername() {
            return this.leadName;
        }

        public String getLead() {
            return this.leadName;
        }

        public String getUrl() {
            return this.url;
        }

        public Long getAssigneeType() {
            return this.assigneeType;
        }

        public Long getAvatarId() {
            return this.avatarId;
        }

        @ExperimentalApi
        public boolean isKeyChanged() {
            return this.keyChanged;
        }
    }

    @PublicApi
    public static class UpdateProjectSchemesValidationResult
    extends ServiceResultImpl {
        private Long permissionSchemeId;
        private Long notificationSchemeId;
        private Long issueSecuritySchemeId;

        public UpdateProjectSchemesValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }

        public UpdateProjectSchemesValidationResult(ErrorCollection errorCollection, Long permissionSchemeId, Long notificationSchemeId, Long issueSecuritySchemeId) {
            super(errorCollection);
            this.permissionSchemeId = permissionSchemeId;
            this.notificationSchemeId = notificationSchemeId;
            this.issueSecuritySchemeId = issueSecuritySchemeId;
        }

        public Long getPermissionSchemeId() {
            return this.permissionSchemeId;
        }

        public Long getNotificationSchemeId() {
            return this.notificationSchemeId;
        }

        public Long getIssueSecuritySchemeId() {
            return this.issueSecuritySchemeId;
        }
    }
}

