/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.customfield;

import com.atlassian.annotations.PublicApi;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;

@PublicApi
public class CustomFieldDefinition {
    private String name;
    private String description;
    private String cfType;
    private String searcherKey;
    private List<Long> projectIds;
    private List<String> issueTypeIds;
    private boolean isGlobal;
    private boolean allIssueTypes;

    public String getCfType() {
        return this.cfType;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSearcherKey() {
        return this.searcherKey;
    }

    public List<Long> getProjectIds() {
        return this.projectIds;
    }

    public List<String> getIssueTypeIds() {
        return this.issueTypeIds;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public boolean isAllIssueTypes() {
        return this.allIssueTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final CustomFieldDefinition instance = new CustomFieldDefinition();

        public Builder() {
            this.instance.projectIds = Lists.newArrayList();
            this.instance.issueTypeIds = Lists.newArrayList();
        }

        public Builder name(String name) {
            this.instance.name = name;
            return this;
        }

        public Builder description(String description) {
            this.instance.description = description;
            return this;
        }

        public Builder cfType(String cfType) {
            this.instance.cfType = cfType;
            return this;
        }

        public Builder searcherKey(String searcherKey) {
            this.instance.searcherKey = searcherKey;
            return this;
        }

        public Builder addProjectIds(Long ... projects) {
            this.instance.projectIds.addAll(Arrays.asList(projects));
            return this;
        }

        public Builder addProjectId(Long project) {
            this.instance.projectIds.add(project);
            return this;
        }

        public Builder isGlobal(boolean isGlobal) {
            this.instance.isGlobal = isGlobal;
            return this;
        }

        public Builder isAllIssueTypes(boolean allIssueTypes) {
            this.instance.allIssueTypes = allIssueTypes;
            return this;
        }

        public Builder addIssueTypeId(String issueTypeId) {
            this.instance.issueTypeIds.add(issueTypeId);
            return this;
        }

        public Builder addIssueTypeIds(String[] issueTypeIds) {
            this.instance.issueTypeIds.addAll(Arrays.asList(issueTypeIds));
            return this;
        }

        public CustomFieldDefinition build() {
            return this.instance;
        }
    }
}

