/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.web.action.util.CalendarLanguageUtil;
import com.atlassian.plugin.webresource.WebResourceManager;
import java.util.Locale;

public class CalendarResourceIncluder {
    private static final String CALENDAR_JS_RESOURCE_KEY = "jira.webresources:calendar";
    private static final String CALENDAR_LOCALISATION_RESOURCE_PREFIX = "jira.webresources:calendar-";
    private static final String OBSOLETE_HEBREW_LANGUAGE_CODE = "iw";
    private static final String CURRENT_HEBREW_LANGUAGE_CODE = "he";

    private CalendarLanguageUtil getCalendarLanguageUtil() {
        return ComponentAccessor.getComponent(CalendarLanguageUtil.class);
    }

    WebResourceManager getWebResourceManager() {
        return ComponentAccessor.getComponent(WebResourceManager.class);
    }

    public boolean hasTranslation(Locale locale) {
        return this.getCalendarLanguageUtil().hasTranslationForLanguage(this.getLanguageCode(locale));
    }

    @Deprecated
    public void includeIfTranslated(Locale locale) {
        if (this.hasTranslation(locale)) {
            this.includeCalendarResources(locale);
        }
    }

    private void includeCalendarResources(Locale locale) {
        this.getWebResourceManager().requireResource(CALENDAR_JS_RESOURCE_KEY);
        this.getWebResourceManager().requireResource(CALENDAR_LOCALISATION_RESOURCE_PREFIX + this.getLanguageCode(locale));
    }

    private String getLanguageCode(Locale locale) {
        if (locale == null) {
            return "unsupported";
        }
        String languageCode = locale.getLanguage();
        if (OBSOLETE_HEBREW_LANGUAGE_CODE.equals(languageCode)) {
            languageCode = CURRENT_HEBREW_LANGUAGE_CODE;
        }
        return languageCode;
    }

    public void includeForLocale(Locale locale) {
        if (this.hasTranslation(locale)) {
            this.includeCalendarResources(locale);
        } else {
            this.includeCalendarResources(null);
        }
    }
}

