/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail.settings;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Preconditions;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MailSetting {
    private static final Logger log = LoggerFactory.getLogger(MailSetting.class);
    private final ApplicationProperties applicationProperties;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final String name;

    public MailSetting(@Nonnull ApplicationProperties applicationProperties, @Nonnull JiraAuthenticationContext jiraAuthenticationContext, @Nonnull String name) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.jiraAuthenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)jiraAuthenticationContext);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean getValue() {
        return this.applicationProperties.getOption(this.name);
    }

    @Nullable
    public String getModifiedBy() {
        return this.applicationProperties.getString(this.modifiedBy());
    }

    @Nullable
    public Date getModifiedDate() {
        String modDateVal = this.applicationProperties.getString(this.modifiedDate());
        Date modDate = null;
        if (StringUtils.isNotBlank((String)modDateVal)) {
            modDate = new Date(Long.parseLong(modDateVal));
        }
        return modDate;
    }

    public void setValue(boolean value) {
        this.applicationProperties.setOption(this.name, value);
        log.info("Mail setting '{}' has been set to '{}'", (Object)this.name, (Object)value);
        if (log.isDebugEnabled()) {
            log.trace("Dumping stack trace for mail setting change", new Throwable());
        }
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        this.applicationProperties.setString(this.modifiedBy(), user != null ? user.getKey() : "");
        this.applicationProperties.setString(this.modifiedDate(), String.valueOf(System.currentTimeMillis()));
    }

    private String modifiedDate() {
        return String.format("mailsetting.%s.modifiedDate", this.name);
    }

    private String modifiedBy() {
        return String.format("mailsetting.%s.modifiedBy", this.name);
    }
}

