/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.annotations.PublicApi;
import java.io.File;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@PublicApi
public class TemporaryAttachment
implements Comparable<TemporaryAttachment> {
    private final Long id;
    private final File tempAttachment;
    private final String filename;
    private final String contentType;
    private final Long issueId;
    private final Date created;

    public TemporaryAttachment(Long id, Long issueId, File tempAttachment, String filename, String contentType) {
        this.id = id;
        this.issueId = issueId;
        this.tempAttachment = tempAttachment;
        this.filename = filename;
        this.contentType = contentType;
        this.created = new Date();
    }

    public Long getId() {
        return this.id;
    }

    public Long getIssueId() {
        return this.issueId;
    }

    public File getFile() {
        return this.tempAttachment;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFilename() {
        return this.filename;
    }

    public Date getCreated() {
        return this.created;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemporaryAttachment that = (TemporaryAttachment)o;
        if (!this.contentType.equals(that.contentType)) {
            return false;
        }
        if (!this.filename.equals(that.filename)) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.issueId.equals(that.issueId)) {
            return false;
        }
        if (!this.tempAttachment.equals(that.tempAttachment)) {
            return false;
        }
        return this.created.equals(that.created);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.tempAttachment != null ? this.tempAttachment.hashCode() : 0);
        result = 31 * result + (this.filename != null ? this.filename.hashCode() : 0);
        result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
        result = 31 * result + (this.issueId != null ? this.issueId.hashCode() : 0);
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(TemporaryAttachment other) {
        return this.created.compareTo(other.getCreated());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

