/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.util.concurrent.ResettableLazyReference;
import org.apache.log4j.Logger;

public final class JiraSystemProperties {
    private static final ResettableLazyReference<Boolean> XSRF_DETECTION_CHECK = new ResettableLazyReference<Boolean>(){

        protected Boolean create() throws Exception {
            return Boolean.getBoolean("xsrf.detection.check");
        }
    };
    private static final ResettableLazyReference<Boolean> JIRA_DEV_MODE = new ResettableLazyReference<Boolean>(){

        protected Boolean create() throws Exception {
            return Boolean.getBoolean("jira.dev.mode");
        }
    };
    private static final ResettableLazyReference<Boolean> ATLASSIAN_DEV_MODE = new ResettableLazyReference<Boolean>(){

        protected Boolean create() throws Exception {
            return Boolean.getBoolean("atlassian.dev.mode");
        }
    };
    private static final ResettableLazyReference<Boolean> DISABLE_BUNDLED_PLUGINS = new ResettableLazyReference<Boolean>(){

        protected Boolean create() throws Exception {
            return Boolean.getBoolean("jira.plugins.bundled.disable");
        }
    };
    private static final ResettableLazyReference<Boolean> CUSTOM_PLUGIN_PATH_ENABLED = new ResettableLazyReference<Boolean>(){

        protected Boolean create() {
            return System.getProperty("atlassian.jira.plugin.scan.directory") != null;
        }
    };
    private static final ResettableLazyReference<Boolean> JIRA_I18N_RELOADBUNDLES = new ResettableLazyReference<Boolean>(){

        protected Boolean create() throws Exception {
            return Boolean.getBoolean("jira.i18n.reloadbundles");
        }
    };
    private static final ResettableLazyReference<Boolean> MAIL_DECODE_PARAMETERS = new ResettableLazyReference<Boolean>(){

        protected Boolean create() throws Exception {
            return JiraSystemProperties.getBooleanSafely("mail.mime.decodeparameters", false);
        }
    };
    private static final ResettableLazyReference<Boolean> MAIL_DECODE_FILENAME = new ResettableLazyReference<Boolean>(){

        protected Boolean create() throws Exception {
            return JiraSystemProperties.getBooleanSafely("mail.mime.decodefilename", false);
        }
    };
    private static final ResettableLazyReference<Boolean> SUPER_BATCH_DISABLED = new ResettableLazyReference<Boolean>(){

        protected Boolean create() throws Exception {
            return JiraSystemProperties.getBooleanSafely("jira.superbatching.disabled", false);
        }
    };
    private static final ResettableLazyReference<Boolean> WEBSUDO_IS_DISABLED = new ResettableLazyReference<Boolean>(){

        protected Boolean create() throws Exception {
            return JiraSystemProperties.getBooleanSafely("jira.websudo.is.disabled", false);
        }
    };
    private static final ResettableLazyReference<Boolean> SHOW_PERF_MONITOR = new ResettableLazyReference<Boolean>(){

        protected Boolean create() throws Exception {
            return JiraSystemProperties.getBooleanSafely("jira.show.perf.monitor", false);
        }
    };

    private JiraSystemProperties() {
    }

    public static boolean isXsrfDetectionCheckRequired() {
        return (Boolean)XSRF_DETECTION_CHECK.get();
    }

    public static boolean isDevMode() {
        return (Boolean)JIRA_DEV_MODE.get() != false || (Boolean)ATLASSIAN_DEV_MODE.get() != false;
    }

    public static boolean isBundledPluginsDisabled() {
        return (Boolean)DISABLE_BUNDLED_PLUGINS.get();
    }

    public static boolean isCustomPathPluginsEnabled() {
        return (Boolean)CUSTOM_PLUGIN_PATH_ENABLED.get();
    }

    public static String getCustomDirectoryPlugins() {
        return System.getProperty("atlassian.jira.plugin.scan.directory");
    }

    public static boolean isI18nReloadBundles() {
        return (Boolean)JIRA_I18N_RELOADBUNDLES.get();
    }

    public static boolean isDecodeMailParameters() {
        return (Boolean)MAIL_DECODE_PARAMETERS.get();
    }

    public static boolean isDecodeMailFileName() {
        return (Boolean)MAIL_DECODE_FILENAME.get();
    }

    public static boolean isSuperBatchingDisabled() {
        return (Boolean)SUPER_BATCH_DISABLED.get();
    }

    public static boolean isWebSudoDisabled() {
        return (Boolean)WEBSUDO_IS_DISABLED.get();
    }

    public static boolean showPerformanceMonitor() {
        return (Boolean)SHOW_PERF_MONITOR.get();
    }

    private static boolean getBooleanSafely(String property, boolean defValue) {
        try {
            String value = System.getProperty(property);
            if (value == null) {
                return defValue;
            }
            return Boolean.parseBoolean(value);
        }
        catch (SecurityException e) {
            JiraSystemProperties.getLogger().warn((Object)("Unable to read system property '" + property + "'. Return default value of '" + defValue + "'."), (Throwable)e);
            return defValue;
        }
    }

    private static Logger getLogger() {
        return Logger.getLogger(JiraSystemProperties.class);
    }

    public static void resetReferences() {
        XSRF_DETECTION_CHECK.reset();
        JIRA_DEV_MODE.reset();
        ATLASSIAN_DEV_MODE.reset();
        DISABLE_BUNDLED_PLUGINS.reset();
        JIRA_I18N_RELOADBUNDLES.reset();
        MAIL_DECODE_PARAMETERS.reset();
        MAIL_DECODE_FILENAME.reset();
        SUPER_BATCH_DISABLED.reset();
        WEBSUDO_IS_DISABLED.reset();
        SHOW_PERF_MONITOR.reset();
    }
}

