/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.security.login;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

@Immutable
public class DeniedReason {
    public static final String X_DENIED_HEADER = "X-Authentication-Denied-Reason";
    private final String reasonCode;
    private final ImmutableMap<String, String> reasonSpecificProperties;

    public DeniedReason(String reasonCode) {
        this(reasonCode, (Map<String, String>)ImmutableMap.of());
    }

    public DeniedReason(String reasonCode, Map<String, String> reasonSpecificProperties) {
        if (reasonCode == null) {
            throw new NullPointerException("reasonCode");
        }
        if (reasonSpecificProperties == null) {
            throw new NullPointerException("properties");
        }
        this.reasonCode = reasonCode;
        this.reasonSpecificProperties = ImmutableMap.copyOf(reasonSpecificProperties);
    }

    public String asString() {
        if (this.reasonSpecificProperties.isEmpty()) {
            return this.reasonCode;
        }
        return String.format("%s; %s", this.reasonCode, StringUtils.join((Collection)this.reasonSpecificProperties.entrySet(), (String)","));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

