/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.customfield;

import com.atlassian.annotations.PublicApi;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@PublicApi
public class CustomFieldDefinition {
    private final String name;
    private final String description;
    private final String cfType;
    private final String searcherKey;
    private final List<Long> projectIds;
    private final List<String> issueTypeIds;
    private final boolean isGlobal;
    private final boolean allIssueTypes;
    private final boolean useDefaultSearcher;

    private CustomFieldDefinition(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.cfType = builder.cfType;
        this.searcherKey = builder.searcherKey;
        this.projectIds = CustomFieldDefinition.copy(builder.projectIds);
        this.issueTypeIds = CustomFieldDefinition.copy(builder.issueTypeIds);
        this.isGlobal = builder.isGlobal;
        this.allIssueTypes = builder.allIssueTypes;
        this.useDefaultSearcher = builder.defaultSearcher;
    }

    private static <T> List<T> copy(Iterable<? extends T> elements) {
        return Collections.unmodifiableList(Lists.newArrayList(elements));
    }

    public String getCfType() {
        return this.cfType;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSearcherKey() {
        return this.searcherKey;
    }

    public boolean isUseDefaultSearcher() {
        return this.useDefaultSearcher;
    }

    public List<Long> getProjectIds() {
        return this.projectIds;
    }

    public List<String> getIssueTypeIds() {
        return this.issueTypeIds;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public boolean isAllIssueTypes() {
        return this.allIssueTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String description;
        private String cfType;
        private String searcherKey;
        private Set<Long> projectIds = Sets.newLinkedHashSet();
        private Set<String> issueTypeIds = Sets.newLinkedHashSet();
        private boolean isGlobal;
        private boolean allIssueTypes;
        private boolean defaultSearcher;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder cfType(String cfType) {
            this.cfType = cfType;
            return this;
        }

        public Builder searcherKey(String searcherKey) {
            this.defaultSearcher = false;
            this.searcherKey = searcherKey;
            return this;
        }

        public Builder defaultSearcher() {
            this.defaultSearcher = true;
            return this;
        }

        public Builder addProjectIds(Long ... projects) {
            this.projectIds.addAll(Arrays.asList(projects));
            return this;
        }

        public Builder addProjectId(Long project) {
            this.projectIds.add(project);
            return this;
        }

        public Builder isGlobal(boolean isGlobal) {
            this.isGlobal = isGlobal;
            return this;
        }

        public Builder isAllIssueTypes(boolean allIssueTypes) {
            this.allIssueTypes = allIssueTypes;
            return this;
        }

        public Builder addIssueTypeId(String issueTypeId) {
            this.issueTypeIds.add(issueTypeId);
            return this;
        }

        public Builder addIssueTypeIds(String ... issueTypeIds) {
            this.issueTypeIds.addAll(Arrays.asList(issueTypeIds));
            return this;
        }

        public CustomFieldDefinition build() {
            return new CustomFieldDefinition(this);
        }
    }
}

