/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.util.JqlIssueKeySupport;
import com.atlassian.jira.jql.util.JqlIssueSupport;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.CaseFolding;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.apache.lucene.document.NumberTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;

@InjectableComponent
public class IssueIdClauseQueryFactory
implements ClauseQueryFactory {
    private static final Logger log = Logger.getLogger(IssueIdClauseQueryFactory.class);
    private final JqlOperandResolver operandResolver;
    private final JqlIssueKeySupport issueKeySupport;
    private final JqlIssueSupport issueSupport;

    public IssueIdClauseQueryFactory(JqlOperandResolver operandResolver, JqlIssueKeySupport issueKeySupport, JqlIssueSupport issueSupport) {
        this.issueSupport = Assertions.notNull("issueSupport", issueSupport);
        this.issueKeySupport = Assertions.notNull("issueKeySupport", issueKeySupport);
        this.operandResolver = Assertions.notNull("operandResolver", operandResolver);
    }

    @Override
    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        Assertions.notNull("queryCreationContext", queryCreationContext);
        Operand operand = terminalClause.getOperand();
        Operator operator = terminalClause.getOperator();
        if (OperatorClasses.EMPTY_ONLY_OPERATORS.contains((Object)operator) && !operand.equals(EmptyOperand.EMPTY)) {
            return QueryFactoryResult.createFalseResult();
        }
        List<QueryLiteral> literals = this.operandResolver.getValues(queryCreationContext, operand, terminalClause);
        if (literals == null) {
            log.debug((Object)String.format("Unable to find operand values from operand '%s' for clause '%s'.", operand.getDisplayString(), terminalClause.getName()));
            return QueryFactoryResult.createFalseResult();
        }
        if (this.isEqualityOperator(operator)) {
            return this.handleEquals(literals);
        }
        if (this.isNegationOperator(operator)) {
            return this.handleNotEquals(literals);
        }
        if (OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains((Object)operator)) {
            if (this.operandResolver.isListOperand(operand)) {
                log.debug((Object)String.format("Tried to use list operand '%s' with relational operator '%s' in clause '%s'.", operand.getDisplayString(), operator.getDisplayString(), terminalClause.getName()));
                return QueryFactoryResult.createFalseResult();
            }
            return this.handleRelational(queryCreationContext.getQueryUser(), queryCreationContext.isSecurityOverriden(), operator, literals, terminalClause);
        }
        log.debug((Object)String.format("The '%s' clause does not support the %s operator.", new Object[]{terminalClause.getName(), operator}));
        return QueryFactoryResult.createFalseResult();
    }

    private QueryFactoryResult handleRelational(User user, boolean overrideSecurity, Operator operator, List<QueryLiteral> literals, TerminalClause clause) {
        return this.handleRelational(user, overrideSecurity, literals, clause, IssueIdClauseQueryFactory.createRangeQueryGenerator(operator));
    }

    private QueryFactoryResult handleRelational(User user, boolean overrideSecurity, List<QueryLiteral> literals, TerminalClause clause, RangeQueryGenerator rangeQueryGenerator) {
        LinkedList<BooleanClause> clauses = new LinkedList<BooleanClause>();
        for (QueryLiteral literal : literals) {
            List<Issue> issues;
            if (literal.isEmpty()) {
                log.debug((Object)String.format("Encountered EMPTY literal from operand '%s' for operator '%s' on clause '%s'. Ignoring.", clause.getOperand().getDisplayString(), clause.getOperator().getDisplayString(), clause.getName()));
            }
            if (literal.getLongValue() != null) {
                Issue issue;
                Issue issue2 = issue = overrideSecurity ? this.issueSupport.getIssue(literal.getLongValue()) : this.issueSupport.getIssue(literal.getLongValue(), user);
                issues = issue != null ? Collections.singletonList(issue) : Collections.emptyList();
            } else if (literal.getStringValue() != null) {
                issues = overrideSecurity ? this.issueSupport.getIssues(literal.getStringValue()) : this.issueSupport.getIssues(literal.getStringValue(), user);
            } else {
                log.debug((Object)String.format("Encountered weird literal from operand '%s' for operator '%s' on clause '%s'. Ignoring.", clause.getOperand().getDisplayString(), clause.getOperator().getDisplayString(), clause.getName()));
                issues = Collections.emptyList();
            }
            for (Issue issue : issues) {
                long currentCount = this.issueKeySupport.parseKeyNum(issue.getKey());
                if (currentCount < 0L) {
                    return QueryFactoryResult.createFalseResult();
                }
                BooleanQuery subQuery = new BooleanQuery();
                subQuery.add(rangeQueryGenerator.get(currentCount), BooleanClause.Occur.MUST);
                subQuery.add(IssueIdClauseQueryFactory.createProjectQuery(issue.getProjectObject()), BooleanClause.Occur.MUST);
                clauses.add(new BooleanClause((Query)subQuery, BooleanClause.Occur.SHOULD));
            }
        }
        return IssueIdClauseQueryFactory.createResult(clauses);
    }

    private QueryFactoryResult handleNotEquals(List<QueryLiteral> rawValues) {
        return new QueryFactoryResult(this.createPositiveEqualsQuery(rawValues), true);
    }

    private QueryFactoryResult handleEquals(List<QueryLiteral> rawValues) {
        return new QueryFactoryResult(this.createPositiveEqualsQuery(rawValues));
    }

    private Query createPositiveEqualsQuery(List<QueryLiteral> rawValues) {
        if (rawValues.size() == 1) {
            return IssueIdClauseQueryFactory.createQuery(rawValues.get(0));
        }
        BooleanQuery query = new BooleanQuery();
        for (QueryLiteral rawValue : rawValues) {
            if (rawValue.isEmpty()) continue;
            query.add(IssueIdClauseQueryFactory.createQuery(rawValue), BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    private static Query createQuery(QueryLiteral rawValue) {
        if (!rawValue.isEmpty()) {
            String value;
            String fieldName;
            if (rawValue.getStringValue() != null) {
                fieldName = SystemSearchConstants.forIssueKey().getIndexField();
                value = CaseFolding.foldString(rawValue.getStringValue(), Locale.ENGLISH);
            } else {
                fieldName = SystemSearchConstants.forIssueId().getIndexField();
                value = rawValue.asString();
            }
            return new TermQuery(new Term(fieldName, value));
        }
        return new BooleanQuery();
    }

    private static Query createProjectQuery(Project project) {
        return new TermQuery(new Term(SystemSearchConstants.forProject().getIndexField(), project.getId().toString()));
    }

    private static Query createRangeQuery(long min, long max, boolean minInclusive, boolean maxInclusive) {
        return new TermRangeQuery(SystemSearchConstants.forIssueKey().getKeyIndexOrderField(), IssueIdClauseQueryFactory.processRangeLong(min), IssueIdClauseQueryFactory.processRangeLong(max), minInclusive, maxInclusive);
    }

    private static String processRangeLong(long value) {
        return value < 0L ? null : NumberTools.longToString((long)value);
    }

    private boolean isNegationOperator(Operator operator) {
        return operator == Operator.NOT_EQUALS || operator == Operator.NOT_IN || operator == Operator.IS_NOT;
    }

    private boolean isEqualityOperator(Operator operator) {
        return operator == Operator.EQUALS || operator == Operator.IN || operator == Operator.IS;
    }

    private static QueryFactoryResult createResult(List<BooleanClause> clauses) {
        if (clauses.isEmpty()) {
            return QueryFactoryResult.createFalseResult();
        }
        if (clauses.size() == 1) {
            return new QueryFactoryResult(clauses.get(0).getQuery());
        }
        BooleanQuery query = new BooleanQuery();
        for (BooleanClause clause : clauses) {
            query.add(clause);
        }
        return new QueryFactoryResult((Query)query);
    }

    private static RangeQueryGenerator createRangeQueryGenerator(Operator operator) {
        switch (operator) {
            case LESS_THAN: {
                return new RangeQueryGenerator(){

                    @Override
                    public Query get(long limit) {
                        return IssueIdClauseQueryFactory.createRangeQuery(-1L, limit, true, false);
                    }
                };
            }
            case LESS_THAN_EQUALS: {
                return new RangeQueryGenerator(){

                    @Override
                    public Query get(long limit) {
                        return IssueIdClauseQueryFactory.createRangeQuery(-1L, limit, true, true);
                    }
                };
            }
            case GREATER_THAN: {
                return new RangeQueryGenerator(){

                    @Override
                    public Query get(long limit) {
                        return IssueIdClauseQueryFactory.createRangeQuery(limit, -1L, false, true);
                    }
                };
            }
            case GREATER_THAN_EQUALS: {
                return new RangeQueryGenerator(){

                    @Override
                    public Query get(long limit) {
                        return IssueIdClauseQueryFactory.createRangeQuery(limit, -1L, true, true);
                    }
                };
            }
        }
        throw new IllegalArgumentException("Unsupported Operator:" + (Object)((Object)operator));
    }

    private static interface RangeQueryGenerator {
        public Query get(long var1);
    }
}

