/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.AbstractActualValueOperatorQueryFactory;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.RangeQueryFactory;
import com.atlassian.jira.jql.util.IndexValueConverter;
import com.atlassian.query.operator.Operator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class ActualValueRelationalQueryFactory
extends AbstractActualValueOperatorQueryFactory
implements OperatorSpecificQueryFactory {
    private static final Logger log = Logger.getLogger(ActualValueRelationalQueryFactory.class);
    private static final RangeQueryFactory<String> RANGE_QUERY_FACTORY = RangeQueryFactory.stringRangeQueryFactory();
    private final String emptyIndexValue;

    public ActualValueRelationalQueryFactory(IndexValueConverter indexValueConverter) {
        this(indexValueConverter, null);
    }

    public ActualValueRelationalQueryFactory(IndexValueConverter indexValueConverter, String emptyIndexValue) {
        super(indexValueConverter);
        this.emptyIndexValue = emptyIndexValue;
    }

    @Override
    public QueryFactoryResult createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (!this.handlesOperator(operator)) {
            log.warn((Object)String.format("ActualValueRelationalQueryFactory does not support operator '%s'.", operator.getDisplayString()));
            return QueryFactoryResult.createFalseResult();
        }
        List<String> values = this.getIndexValues(rawValues);
        if (values.isEmpty()) {
            return QueryFactoryResult.createFalseResult();
        }
        String value = values.get(0);
        if (value == null) {
            log.warn((Object)"Relation operators do not support empty values");
            return QueryFactoryResult.createFalseResult();
        }
        Query query = RANGE_QUERY_FACTORY.get(operator, fieldName, value);
        if (this.emptyIndexValue != null) {
            BooleanQuery combined = new BooleanQuery();
            combined.add(query, BooleanClause.Occur.MUST);
            combined.add((Query)new TermQuery(new Term(fieldName, this.emptyIndexValue)), BooleanClause.Occur.MUST_NOT);
            query = combined;
        }
        return new QueryFactoryResult(query);
    }

    @Override
    public QueryFactoryResult createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        log.warn((Object)"Relation operators do not support multivalue operands");
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public QueryFactoryResult createQueryForEmptyOperand(String fieldName, Operator operator) {
        log.warn((Object)"Relation operators do not support multivalue empty");
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains((Object)operator);
    }
}

