/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

public class UserSearchParams {
    public static final UserSearchParams ACTIVE_USERS_IGNORE_EMPTY_QUERY = new UserSearchParams(false, true, false);
    public static final UserSearchParams ACTIVE_USERS_ALLOW_EMPTY_QUERY = new UserSearchParams(true, true, false);
    private final boolean allowEmptyQuery;
    private final boolean includeActive;
    private final boolean includeInactive;

    public UserSearchParams(boolean allowEmptyQuery, boolean includeActive, boolean includeInactive) {
        this.allowEmptyQuery = allowEmptyQuery;
        this.includeActive = includeActive;
        this.includeInactive = includeInactive;
    }

    public boolean allowEmptyQuery() {
        return this.allowEmptyQuery;
    }

    public boolean includeActive() {
        return this.includeActive;
    }

    public boolean includeInactive() {
        return this.includeInactive;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean allowEmptyQuery = false;
        private boolean includeActive = true;
        private boolean includeInactive = false;

        public UserSearchParams build() {
            return new UserSearchParams(this.allowEmptyQuery, this.includeActive, this.includeInactive);
        }

        public Builder allowEmptyQuery(boolean allowEmptyQuery) {
            this.allowEmptyQuery = allowEmptyQuery;
            return this;
        }

        public Builder includeActive(boolean includeActive) {
            this.includeActive = includeActive;
            return this;
        }

        public Builder includeInactive(boolean includeInactive) {
            this.includeInactive = includeInactive;
            return this;
        }
    }
}

