/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.type.NotificationType;
import java.util.HashMap;
import java.util.Map;

@PublicApi
public interface NotificationFilter {
    public Iterable<NotificationRecipient> add(Context var1);

    public boolean remove(NotificationRecipient var1, Context var2);

    public static class Context {
        private final Reason reason;
        private final IssueEvent event;
        private final Map<String, Object> state = new HashMap<String, Object>();
        private NotificationType notificationType;

        public Context(Reason reason) {
            this(reason, null);
        }

        public Context(Reason reason, IssueEvent event) {
            this.reason = reason;
            this.event = event;
        }

        public Context(Reason reason, IssueEvent event, NotificationType notificationType) {
            this.reason = reason;
            this.event = event;
            this.notificationType = notificationType;
        }

        public Reason getReason() {
            return this.reason;
        }

        public IssueEvent getEvent() {
            return this.event;
        }

        public NotificationType getNotificationType() {
            return this.notificationType;
        }

        public void setNotificationType(NotificationType notificationType) {
            this.notificationType = notificationType;
        }

        public Object get(String stateKey) {
            return this.state.get(stateKey);
        }

        public Object put(String stateKey, Object stateValue) {
            return this.state.put(stateKey, stateValue);
        }
    }

    public static enum Reason {
        ISSUE_EVENT,
        MENTIONED,
        SHARED,
        ADHOC_NOTIIFCATION;

    }
}

