/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.table;

import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class IssueTable {
    @XmlElement
    private String table;
    @XmlElement
    private int displayed;
    @XmlElement
    private int startIndex;
    @XmlElement
    private int total;
    @XmlElement
    private int end;
    @XmlElement
    private int page;
    @XmlElement
    private int pageSize;
    @XmlElement
    private String url;
    @XmlElement
    private String title;
    @XmlElement
    private String description;
    @XmlElement
    private Map<String, String> columnSortJql;
    @XmlElement
    private boolean jiraHasIssues;
    @XmlElement
    private List<Long> issueIds;
    @XmlElement
    private List<String> issueKeys;

    private IssueTable() {
    }

    public String getTable() {
        return this.table;
    }

    public int getTotal() {
        return this.total;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean getJiraHasIssues() {
        return this.jiraHasIssues;
    }

    public List<Long> getIssueIds() {
        return this.issueIds;
    }

    public List<String> getIssueKeys() {
        return this.issueKeys;
    }

    private IssueTable(Builder builder) {
        this.table = builder.table;
        this.displayed = builder.displayed;
        this.total = builder.total;
        this.startIndex = builder.startIndex;
        this.end = builder.end;
        this.page = builder.page;
        this.pageSize = builder.pageSize;
        this.url = builder.url;
        this.title = builder.title;
        this.description = builder.description;
        this.columnSortJql = builder.columnSortJql;
        this.jiraHasIssues = builder.jiraHasIssues;
        this.issueIds = builder.issueIds;
        this.issueKeys = builder.issueKeys;
    }

    public static class Builder {
        private final String table;
        private int displayed;
        private int total;
        private int startIndex;
        private int end;
        private int page;
        private int pageSize;
        private String url;
        private String title;
        private String description;
        private Map<String, String> columnSortJql;
        private boolean jiraHasIssues;
        private List<Long> issueIds;
        private List<String> issueKeys;

        public Builder(String table) {
            this.table = table;
        }

        public Builder displayed(int displayed) {
            this.displayed = displayed;
            return this;
        }

        public Builder total(int total) {
            this.total = total;
            return this;
        }

        public Builder startIndex(int startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public Builder end(int end) {
            this.end = end;
            return this;
        }

        public Builder page(int page) {
            this.page = page;
            return this;
        }

        public Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder columnSortJql(Map<String, String> columnSortJql) {
            this.columnSortJql = columnSortJql;
            return this;
        }

        public Builder jiraHasIssues(boolean jiraHasIssues) {
            this.jiraHasIssues = jiraHasIssues;
            return this;
        }

        public Builder issueIds(List<Long> issueIds) {
            this.issueIds = issueIds;
            return this;
        }

        public Builder issueKeys(List<String> issueKeys) {
            this.issueKeys = issueKeys;
            return this;
        }

        public IssueTable build() {
            return new IssueTable(this);
        }
    }
}

