/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.query.operand;

import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.OperandVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class FunctionOperand
implements Operand {
    private final String name;
    private final List<String> args;
    private String caseInsensitiveName = null;

    public FunctionOperand(String name) {
        this(name, Collections.emptyList());
    }

    public FunctionOperand(String name, String ... args) {
        this(name, Arrays.asList((Object[])Assertions.notNull("args", args)));
    }

    public FunctionOperand(String name, Collection<String> args) {
        this.name = Assertions.notNull("name", name);
        this.args = CollectionUtil.copyAsImmutableList(Assertions.notNull("args", args));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayString() {
        if (this.args.isEmpty()) {
            return this.name + "()";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append("(");
        boolean first = true;
        for (String arg : this.args) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(arg);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public <R> R accept(OperandVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public List<String> getArgs() {
        return this.args;
    }

    private String getCaseInsensitiveName() {
        if (this.caseInsensitiveName == null) {
            this.caseInsensitiveName = this.name.toLowerCase();
        }
        return this.caseInsensitiveName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionOperand that = (FunctionOperand)o;
        if (!((Object)this.args).equals(that.args)) {
            return false;
        }
        return this.getCaseInsensitiveName().equals(that.getCaseInsensitiveName());
    }

    public int hashCode() {
        int result = this.getCaseInsensitiveName().hashCode();
        result = 31 * result + ((Object)this.args).hashCode();
        return result;
    }
}

