/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.issue.comparator.VersionComparator;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.query.operator.Operator;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;

public class VersionStatisticsMapper
implements StatisticsMapper {
    private final VersionManager versionManager;
    private final String clauseName;
    private final String documentConstant;
    boolean includeArchived = false;

    public VersionStatisticsMapper(String clauseName, String documentConstant, VersionManager versionManager, boolean includeArchived) {
        this.clauseName = clauseName;
        this.documentConstant = documentConstant;
        this.versionManager = versionManager;
        this.includeArchived = includeArchived;
    }

    @Override
    public Comparator getComparator() {
        return VersionComparator.COMPARATOR;
    }

    public boolean isValidValue(Object value) {
        if (value == null) {
            return true;
        }
        if (!this.includeArchived) {
            return !((Version)value).isArchived();
        }
        return true;
    }

    @Override
    public Object getValueFromLuceneField(String documentValue) {
        long versionId;
        if (StringUtils.isNotBlank((String)documentValue) && (versionId = Long.parseLong(documentValue)) > 0L) {
            return this.versionManager.getVersion(new Long(versionId));
        }
        return null;
    }

    public SearchRequest getSearchUrlSuffix(Object value, SearchRequest searchRequest) {
        if (searchRequest == null) {
            return null;
        }
        JqlClauseBuilder builder = JqlQueryBuilder.newBuilder(searchRequest.getQuery()).where().defaultAnd();
        if (value != null) {
            Version version = (Version)value;
            builder.project(version.getProjectObject().getKey());
            builder.addStringCondition(this.getClauseName(), Operator.EQUALS, version.getName());
        } else {
            builder.addEmptyCondition(this.getClauseName());
        }
        return new SearchRequest(builder.buildQuery());
    }

    protected String getClauseName() {
        return this.clauseName;
    }

    @Override
    public boolean isFieldAlwaysPartOfAnIssue() {
        return true;
    }

    @Override
    public String getDocumentConstant() {
        return this.documentConstant;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionStatisticsMapper that = (VersionStatisticsMapper)o;
        if (this.includeArchived != that.includeArchived) {
            return false;
        }
        return this.getDocumentConstant() != null ? this.getDocumentConstant().equals(that.getDocumentConstant()) : that.getDocumentConstant() == null;
    }

    @Override
    public int hashCode() {
        int result = this.includeArchived ? 1 : 0;
        result = 29 * result + (this.getDocumentConstant() != null ? this.getDocumentConstant().hashCode() : 0);
        return result;
    }
}

