/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts.jfreechart;

import com.atlassian.core.util.RandomGenerator;
import com.atlassian.util.profiling.UtilTimerStack;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.servlet.ServletUtilities;

public class ChartHelper {
    private static final Logger log = Logger.getLogger(ChartHelper.class);
    private JFreeChart chart;
    private ChartRenderingInfo renderingInfo = null;
    private String location = null;
    private String imageMap;
    private String imageMapName;

    public ChartHelper(JFreeChart chart) {
        this.chart = chart;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(int width, int height) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ChartHelper.generate() Create a ChartRenderingInfo.");
        }
        this.renderingInfo = new ChartRenderingInfo();
        String logLine = "ChartHelper calling JFreeChart: ServletUtilities.saveChartAsPNG()";
        UtilTimerStack.push((String)"ChartHelper calling JFreeChart: ServletUtilities.saveChartAsPNG()");
        try {
            log.info((Object)"ChartHelper.generate(): Use JFreeChart to create PNG file.");
            this.location = ServletUtilities.saveChartAsPNG((JFreeChart)this.chart, (int)width, (int)height, (ChartRenderingInfo)this.renderingInfo, null);
            log.info((Object)("ChartHelper.generate(): PNG file created in '" + this.location + "'."));
        }
        finally {
            UtilTimerStack.pop((String)"ChartHelper calling JFreeChart: ServletUtilities.saveChartAsPNG()");
        }
    }

    public ChartRenderingInfo getRenderingInfo() {
        return this.renderingInfo;
    }

    public String getLocation() {
        return this.location;
    }

    public String getImageMap() {
        if (this.imageMap == null) {
            this.imageMapName = "chart-" + RandomGenerator.randomString((int)5);
            this.imageMap = ChartUtilities.getImageMap((String)this.imageMapName, (ChartRenderingInfo)this.renderingInfo);
        }
        return this.imageMap;
    }

    public String getImageMapName() {
        return this.imageMapName;
    }
}

