/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.context.AbstractProjectAttributeClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.VersionIndexInfoResolver;
import com.atlassian.jira.jql.resolver.VersionResolver;
import com.atlassian.jira.jql.util.JqlVersionPredicate;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class VersionClauseContextFactory
extends AbstractProjectAttributeClauseContextFactory<Version>
implements ClauseContextFactory {
    private final JqlOperandResolver jqlOperandResolver;
    private final VersionResolver versionResolver;

    public VersionClauseContextFactory(JqlOperandResolver jqlOperandResolver, VersionResolver versionResolver, PermissionManager permissionManager) {
        super(new VersionIndexInfoResolver(versionResolver), jqlOperandResolver, permissionManager);
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
        this.versionResolver = Assertions.notNull("versionResolver", versionResolver);
    }

    @Override
    ClauseContext getContextFromClause(User searcher, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (!this.handlesOperator(operator)) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        List<QueryLiteral> literals = this.jqlOperandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        ArrayList<Version> specifiedVersions = new ArrayList<Version>();
        boolean containsEmpty = false;
        if (literals != null) {
            for (QueryLiteral literal : literals) {
                if (literal.isEmpty()) {
                    containsEmpty = true;
                    continue;
                }
                List<Long> ids = this.getIds(literal);
                for (Long l : ids) {
                    specifiedVersions.add(this.versionResolver.get(l));
                }
            }
        }
        if (!specifiedVersions.isEmpty()) {
            ArrayList<Object> contextVersions;
            if (this.isRelationalOperator(operator)) {
                contextVersions = new ArrayList();
                for (Version specifiedVersion : specifiedVersions) {
                    JqlVersionPredicate predicate = new JqlVersionPredicate(operator, specifiedVersion);
                    for (Version matchedVersion : CollectionUtil.filter(this.versionResolver.getAll(), predicate)) {
                        contextVersions.add(matchedVersion);
                    }
                }
            } else if (this.isNegationOperator(operator)) {
                contextVersions = new ArrayList<Version>(this.versionResolver.getAll());
                contextVersions.removeAll(specifiedVersions);
            } else {
                contextVersions = specifiedVersions;
            }
            HashSet<ProjectIssueTypeContext> contexts = new HashSet<ProjectIssueTypeContext>();
            HashSet<Long> checkedProjects = new HashSet<Long>();
            for (Version version : contextVersions) {
                if (checkedProjects.contains(version.getProjectId())) continue;
                contexts.addAll(this.getContextsForProject(searcher, version.getProjectObject()));
                checkedProjects.add(version.getProjectId());
            }
            if (containsEmpty) {
                contexts.add(ProjectIssueTypeContextImpl.createGlobalContext());
            }
            return new ClauseContextImpl(contexts);
        }
        return ClauseContextImpl.createGlobalClauseContext();
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator) || OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains((Object)operator);
    }
}

