/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;

public class UserJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String name;
    @JsonProperty
    private String emailAddress;
    @JsonProperty
    private Map<String, String> avatarUrls;
    @JsonProperty
    private String displayName;
    @JsonProperty
    private boolean active;
    public static final UserJsonBean USER_DOC_EXAMPLE = new UserJsonBean();
    public static final UserJsonBean USER_SHORT_DOC_EXAMPLE = new UserJsonBean();

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public Map<String, String> getAvatarUrls() {
        return this.avatarUrls;
    }

    public void setAvatarUrls(Map<String, String> avatarUrls) {
        this.avatarUrls = avatarUrls;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public static Collection<UserJsonBean> shortBeans(Collection<User> users, JiraBaseUrls urls) {
        if (users == null) {
            return null;
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)users.size());
        for (User from : users) {
            result.add(UserJsonBean.shortBean(from, urls));
        }
        return result;
    }

    public static UserJsonBean shortBean(User user, JiraBaseUrls urls) {
        if (user == null) {
            return null;
        }
        UserJsonBean bean = new UserJsonBean();
        bean.self = urls.restApi2BaseUrl() + "user?username=" + JiraUrlCodec.encode(user.getName());
        bean.name = user.getName();
        bean.displayName = user.getDisplayName();
        bean.emailAddress = user.getEmailAddress();
        bean.active = user.isActive();
        bean.avatarUrls = UserJsonBean.getAvatarURLs(user);
        return bean;
    }

    private static Map<String, String> getAvatarURLs(User user) {
        AvatarService avatarService = ComponentAccessor.getAvatarService();
        return MapBuilder.newBuilder().add("16x16", avatarService.getAvatarAbsoluteURL(user, user.getName(), Avatar.Size.SMALL).toString()).add("48x48", avatarService.getAvatarAbsoluteURL(user, user.getName(), Avatar.Size.LARGE).toString()).toMap();
    }

    static {
        USER_DOC_EXAMPLE.setSelf("http://www.example.com/jira/rest/api/2.0/user?username=fred");
        USER_DOC_EXAMPLE.setName("fred");
        USER_DOC_EXAMPLE.setEmailAddress("fred@example.com");
        USER_DOC_EXAMPLE.setDisplayName("Fred F. User");
        USER_DOC_EXAMPLE.setActive(true);
        USER_DOC_EXAMPLE.setAvatarUrls(MapBuilder.newBuilder().add("16x16", "http://www.example.com/jira/secure/useravatar?size=small&ownerId=fred").add("48x48", "http://www.example.com/jira/secure/useravatar?size=large&ownerId=fred").toMap());
        USER_SHORT_DOC_EXAMPLE.setSelf(USER_DOC_EXAMPLE.getSelf());
        USER_SHORT_DOC_EXAMPLE.setName(USER_DOC_EXAMPLE.getName());
        USER_SHORT_DOC_EXAMPLE.setDisplayName(USER_DOC_EXAMPLE.getDisplayName());
    }
}

