/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts.jfreechart.util;

import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.jfreechart.util.ChartDefaults;
import com.atlassian.jira.util.I18nHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;
import org.jfree.ui.HorizontalAlignment;

public class ChartUtil {
    public static Class getTimePeriodClass(ChartFactory.PeriodName periodName) {
        switch (periodName) {
            case daily: {
                return Day.class;
            }
            case hourly: {
                return Hour.class;
            }
            case weekly: {
                return Week.class;
            }
            case monthly: {
                return Month.class;
            }
            case quarterly: {
                return Quarter.class;
            }
            case yearly: {
                return Year.class;
            }
        }
        return Day.class;
    }

    public static void setDefaults(JFreeChart chart, I18nHelper i18nHelper) {
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setBorderVisible(false);
        chart.getPlot().setNoDataMessage(i18nHelper.getText("gadget.charts.no.data"));
        ChartUtil.setupPlot(chart.getPlot());
        ChartUtil.setupTextTitle(chart.getTitle());
        ChartUtil.setupLegendTitle(chart.getLegend());
    }

    public static void setupPlot(Plot plot) {
        if (plot instanceof CategoryPlot) {
            ChartUtil.setupPlot((CategoryPlot)plot);
        } else if (plot instanceof XYPlot) {
            ChartUtil.setupPlot((XYPlot)plot);
        }
    }

    public static void setupPlot(CategoryPlot plot) {
        plot.setBackgroundPaint((Paint)ChartDefaults.transparent);
        plot.setOutlinePaint((Paint)ChartDefaults.transparent);
        plot.setRangeGridlinePaint((Paint)ChartDefaults.gridLineColor);
        plot.setRangeGridlineStroke((Stroke)new BasicStroke(0.5f));
        plot.setRangeGridlinesVisible(true);
        plot.setRangeAxisLocation(ChartDefaults.rangeAxisLocation);
        plot.setDomainGridlinesVisible(false);
        ChartUtil.setupRangeAxis(plot.getRangeAxis());
        ChartUtil.setupDomainAxis(plot.getDomainAxis());
    }

    public static void setupPlot(XYPlot plot) {
        plot.setBackgroundPaint((Paint)ChartDefaults.transparent);
        plot.setOutlinePaint((Paint)ChartDefaults.transparent);
        plot.setRangeGridlinePaint((Paint)ChartDefaults.gridLineColor);
        plot.setRangeGridlineStroke((Stroke)new BasicStroke(0.5f));
        plot.setRangeGridlinesVisible(true);
        plot.setRangeAxisLocation(ChartDefaults.rangeAxisLocation);
        plot.setDomainGridlinesVisible(true);
        ChartUtil.setupRangeAxis(plot.getRangeAxis());
        ChartUtil.setupDomainAxis(plot.getDomainAxis());
    }

    public static void setupRangeAxis(ValueAxis rangeAxis) {
        if (rangeAxis != null) {
            rangeAxis.setAxisLinePaint((Paint)ChartDefaults.gridLineColor);
            rangeAxis.setTickLabelPaint((Paint)ChartDefaults.axisLabelColor);
            rangeAxis.setTickMarksVisible(false);
            rangeAxis.setAxisLineVisible(false);
        }
    }

    public static void setupDomainAxis(CategoryAxis domainAxis) {
        if (domainAxis != null) {
            domainAxis.setAxisLineStroke((Stroke)new BasicStroke(0.5f));
            domainAxis.setAxisLinePaint((Paint)Color.BLACK);
            domainAxis.setTickLabelPaint((Paint)ChartDefaults.axisLabelColor);
        }
    }

    public static void setupDomainAxis(ValueAxis domainAxis) {
        if (domainAxis != null) {
            domainAxis.setAxisLineStroke((Stroke)new BasicStroke(0.5f));
            domainAxis.setAxisLinePaint((Paint)ChartDefaults.axisLineColor);
            domainAxis.setTickLabelPaint((Paint)ChartDefaults.axisLabelColor);
        }
    }

    public static void setupTextTitle(TextTitle title) {
        if (title != null) {
            title.setFont(ChartDefaults.titleFont);
            title.setTextAlignment(HorizontalAlignment.LEFT);
            title.setPaint((Paint)ChartDefaults.titleTextColor);
            title.setBackgroundPaint((Paint)ChartDefaults.transparent);
        }
    }

    public static void setupLegendTitle(LegendTitle legend) {
        if (legend != null) {
            legend.setBorder(0.0, 0.0, 0.0, 0.0);
            legend.setItemPaint((Paint)ChartDefaults.legendTextColor);
            legend.setMargin(2.0, 2.0, 2.0, 2.0);
        }
    }
}

