/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LocaleParser {
    private static final Map<String, Locale> localeCache = new ConcurrentHashMap<String, Locale>(10, 0.75f, 1);

    public static Locale parseLocale(String localeString) {
        if (localeString == null || localeString.length() == 0) {
            return null;
        }
        Locale locale = localeCache.get(localeString);
        if (locale != null) {
            return locale;
        }
        locale = LocaleParser.computeLocale(localeString);
        localeCache.put(localeString, locale);
        return locale;
    }

    private static Locale computeLocale(String localeString) {
        int _pos = localeString.indexOf("_");
        Locale locale = _pos != -1 ? new Locale(localeString.substring(0, _pos), localeString.substring(_pos + 1)) : new Locale(localeString);
        return locale;
    }
}

