/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.SearchContextVisibilityChecker;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VersionSearchContextVisibilityChecker
implements SearchContextVisibilityChecker {
    private final VersionManager versionManager;

    public VersionSearchContextVisibilityChecker(VersionManager versionManager) {
        this.versionManager = versionManager;
    }

    @Override
    public Set<String> FilterOutNonVisibleInContext(SearchContext searchContext, Collection<String> ids) {
        List<Long> projects = searchContext.getProjectIds();
        if (projects.size() != 1) {
            return Collections.emptySet();
        }
        HashSet<String> visibleIds = new HashSet<String>();
        for (String sid : ids) {
            Long pid;
            Version version;
            Long lid = this.parseLong(sid);
            if (lid == null || (version = this.versionManager.getVersion(lid)) == null || !projects.contains(pid = version.getProjectObject().getId())) continue;
            visibleIds.add(sid);
        }
        return visibleIds;
    }

    private Long parseLong(String str) {
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }
}

