/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operator.Operator;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public class ProjectStatisticsMapper
implements StatisticsMapper {
    private final ProjectManager projectManager;
    private final String clauseName;
    private final String documentConstant;

    public ProjectStatisticsMapper(ProjectManager projectManager) {
        this(projectManager, SystemSearchConstants.forProject());
    }

    public ProjectStatisticsMapper(ProjectManager projectManager, SimpleFieldSearchConstants searchConstants) {
        this(projectManager, searchConstants.getJqlClauseNames().getPrimaryName(), searchConstants.getIndexField());
    }

    public ProjectStatisticsMapper(ProjectManager projectManager, String clauseName, String documentConstant) {
        this.projectManager = projectManager;
        this.clauseName = clauseName;
        this.documentConstant = documentConstant;
    }

    @Override
    public String getDocumentConstant() {
        return this.documentConstant;
    }

    @Override
    public Object getValueFromLuceneField(String documentValue) {
        long projectId;
        if (StringUtils.isNotBlank((String)documentValue) && (projectId = Long.parseLong(documentValue)) > 0L) {
            return this.projectManager.getProject(projectId);
        }
        return null;
    }

    @Override
    public Comparator getComparator() {
        return OfBizComparators.NAME_COMPARATOR;
    }

    public boolean isValidValue(Object value) {
        return true;
    }

    @Override
    public boolean isFieldAlwaysPartOfAnIssue() {
        return true;
    }

    public SearchRequest getSearchUrlSuffix(Object value, SearchRequest searchRequest) {
        if (searchRequest == null) {
            return null;
        }
        JqlClauseBuilder builder = JqlQueryBuilder.newBuilder(searchRequest.getQuery()).where().defaultAnd();
        if (value != null) {
            Long projectId = ((GenericValue)value).getLong("id");
            Project project = this.projectManager.getProjectObj(projectId);
            builder.addClause(new TerminalClauseImpl(this.getClauseName(), Operator.EQUALS, project.getKey()));
        } else {
            builder.addEmptyCondition(this.getClauseName());
        }
        return new SearchRequest(builder.buildQuery());
    }

    protected String getClauseName() {
        return this.clauseName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectStatisticsMapper that = (ProjectStatisticsMapper)o;
        return this.getDocumentConstant() != null ? this.getDocumentConstant().equals(that.getDocumentConstant()) : that.getDocumentConstant() == null;
    }

    @Override
    public int hashCode() {
        return this.getDocumentConstant() != null ? this.getDocumentConstant().hashCode() : 0;
    }
}

