/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public class WatchersJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private long watchCount;
    @JsonProperty(value="isWatching")
    private boolean watching;
    @JsonProperty
    private Collection<UserJsonBean> watchers;

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public long getWatchCount() {
        return this.watchCount;
    }

    public void setWatchCount(long watchCount) {
        this.watchCount = watchCount;
    }

    @JsonIgnore
    public boolean isWatching() {
        return this.watching;
    }

    public void setWatching(boolean watching) {
        this.watching = watching;
    }

    public Collection<UserJsonBean> getWatchers() {
        return this.watchers;
    }

    public void setWatchers(Collection<UserJsonBean> watchers) {
        this.watchers = watchers;
    }

    public static WatchersJsonBean shortBean(String issueKey, long watchers, boolean isWatching, JiraBaseUrls urls) {
        WatchersJsonBean bean = new WatchersJsonBean();
        bean.self = urls.restApi2BaseUrl() + "issue/" + issueKey + "/watchers";
        bean.watching = isWatching;
        bean.watchCount = watchers;
        return bean;
    }

    public static WatchersJsonBean fullBean(String issueKey, long watchers, boolean isWatching, Collection<User> watcherrs, final JiraBaseUrls urls) {
        WatchersJsonBean bean = WatchersJsonBean.shortBean(issueKey, watchers, isWatching, urls);
        bean.watchers = Collections2.transform(watcherrs, (Function)new Function<User, UserJsonBean>(){

            public UserJsonBean apply(User from) {
                return UserJsonBean.shortBean(from, urls);
            }
        });
        return bean;
    }
}

