/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.componentpanel.impl;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.componentpanel.BrowseComponentContext;
import com.atlassian.jira.plugin.componentpanel.ComponentTabPanel;
import com.atlassian.jira.plugin.componentpanel.ComponentTabPanelModuleDescriptor;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.HashMap;
import java.util.Map;

@PublicSpi
public class GenericTabPanel
implements ComponentTabPanel {
    protected ComponentTabPanelModuleDescriptor descriptor;
    protected final ProjectManager projectManager;
    protected final JiraAuthenticationContext authenticationContext;
    private final FieldVisibilityManager fieldVisibilityManager;

    public GenericTabPanel(ProjectManager projectManager, JiraAuthenticationContext authenticationContext) {
        this(projectManager, authenticationContext, ComponentAccessor.getComponent(FieldVisibilityManager.class));
    }

    public GenericTabPanel(ProjectManager projectManager, JiraAuthenticationContext authenticationContext, FieldVisibilityManager fieldVisibilityManager) {
        this.projectManager = projectManager;
        this.authenticationContext = authenticationContext;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    @Override
    public void init(ComponentTabPanelModuleDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public String getHtml(BrowseComponentContext context) {
        Map<String, Object> startingParams = this.createVelocityParams(context);
        startingParams.put("fieldVisibility", this.fieldVisibilityManager);
        return this.descriptor.getHtml("view", startingParams);
    }

    @Override
    public boolean showPanel(BrowseComponentContext context) {
        return !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(context.getComponent().getProjectId(), "components");
    }

    protected Map<String, Object> createVelocityParams(BrowseComponentContext context) {
        HashMap<String, Object> startingParams = new HashMap<String, Object>();
        startingParams.put("project", context.getProject());
        startingParams.put("component", context.getComponent());
        startingParams.put("componentContext", context);
        return startingParams;
    }
}

