/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.KickassSearchContext;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.impl.NamedTerminalClauseCollectingVisitor;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.SearchContextVisibilityChecker;
import com.atlassian.jira.issue.search.searchers.util.IndexedInputHelper;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

@NonInjectableComponent
public class DefaultIndexedInputHelper<T>
implements IndexedInputHelper {
    private static final Logger log = Logger.getLogger(DefaultIndexedInputHelper.class);
    private final JqlOperandResolver operandResolver;
    private final IndexInfoResolver<T> indexInfoResolver;
    private final FieldFlagOperandRegistry fieldFlagOperandRegistry;
    private final SearchContextVisibilityChecker searchContextVisibilityChecker;
    private final KickassSearchContext kickassSearchContext;

    public DefaultIndexedInputHelper(IndexInfoResolver<T> indexInfoResolver, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, SearchContextVisibilityChecker searchContextVisibilityChecker) {
        this.operandResolver = operandResolver;
        this.indexInfoResolver = indexInfoResolver;
        this.fieldFlagOperandRegistry = fieldFlagOperandRegistry;
        this.searchContextVisibilityChecker = searchContextVisibilityChecker;
        this.kickassSearchContext = ComponentAccessor.getComponent(KickassSearchContext.class);
    }

    @Override
    public Set<String> getAllIndexValuesForMatchingClauses(User searcher, ClauseNames jqlClauseNames, Query query, SearchContext searchContext) {
        LinkedHashSet<String> allValues = new LinkedHashSet<String>();
        List<TerminalClause> clauses = this.getMatchingClauses(jqlClauseNames.getJqlFieldNames(), query);
        for (TerminalClause clause : clauses) {
            allValues.addAll(this.getAllIndexValuesAsStrings(searcher, searchContext, clause.getOperand(), clause));
        }
        return allValues;
    }

    @Override
    public Set<String> getAllNavigatorValuesForMatchingClauses(User searcher, ClauseNames jqlClauseNames, Query query, SearchContext searchContext) {
        LinkedHashSet<String> allValues = new LinkedHashSet<String>();
        List<TerminalClause> clauses = this.getMatchingClauses(jqlClauseNames.getJqlFieldNames(), query);
        for (TerminalClause clause : clauses) {
            allValues.addAll(this.getAllNavigatorValues(searcher, searchContext, jqlClauseNames.getPrimaryName(), clause.getOperand(), clause));
        }
        return allValues;
    }

    @Override
    public Clause getClauseForNavigatorValues(String clauseName, Set<String> values) {
        Assertions.notNull("values", values);
        ArrayList<Operand> operandValues = new ArrayList<Operand>();
        boolean containsList = false;
        for (String stringValue : values) {
            Operand operand = this.fieldFlagOperandRegistry.getOperandForFlag(clauseName, stringValue);
            if (operand != null) {
                operandValues.add(operand);
                containsList = this.operandResolver.isListOperand(operand);
                continue;
            }
            SingleValueOperand o = this.createSingleValueOperandFromId(stringValue);
            operandValues.add(o);
        }
        if (operandValues.size() == 1) {
            return new TerminalClauseImpl(clauseName, containsList ? Operator.IN : Operator.EQUALS, (Operand)operandValues.get(0));
        }
        if (operandValues.size() > 1) {
            return new TerminalClauseImpl(clauseName, Operator.IN, new MultiValueOperand(operandValues));
        }
        return null;
    }

    protected SingleValueOperand createSingleValueOperandFromId(String stringValue) {
        SingleValueOperand o;
        try {
            o = new SingleValueOperand(new Long(stringValue));
        }
        catch (NumberFormatException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Got a strange non-id input '" + stringValue + "' - continuing anyway so that clause is still constructed."));
            }
            o = new SingleValueOperand(stringValue);
        }
        return o;
    }

    Set<String> getAllNavigatorValues(User searcher, SearchContext searchContext, String fieldName, Operand operand, TerminalClause clause) {
        Set<String> flags = this.fieldFlagOperandRegistry.getFlagForOperand(fieldName, operand);
        if (flags != null) {
            return flags;
        }
        if (operand instanceof MultiValueOperand) {
            MultiValueOperand multiValueOperand = (MultiValueOperand)operand;
            LinkedHashSet<String> values = new LinkedHashSet<String>();
            for (Operand subOperand : multiValueOperand.getValues()) {
                values.addAll(this.getAllNavigatorValues(searcher, searchContext, fieldName, subOperand, clause));
            }
            return values;
        }
        return this.getAllIndexValuesAsStrings(searcher, searchContext, operand, clause);
    }

    private Set<String> getAllIndexValuesAsStrings(User searcher, SearchContext searchContext, Operand operand, TerminalClause clause) {
        LinkedHashSet<String> allValues = new LinkedHashSet<String>();
        List<QueryLiteral> values = this.operandResolver.getValues(searcher, operand, clause);
        if (values != null) {
            for (QueryLiteral literal : values) {
                List<String> idsAsStrings;
                if (literal.getStringValue() != null) {
                    idsAsStrings = this.indexInfoResolver.getIndexedValues(literal.getStringValue());
                } else {
                    if (literal.getLongValue() == null) continue;
                    idsAsStrings = this.indexInfoResolver.getIndexedValues(literal.getLongValue());
                }
                if (idsAsStrings == null) continue;
                allValues.addAll(idsAsStrings);
            }
        }
        if (!(searchContext == null || allValues.isEmpty() || null != this.kickassSearchContext && this.kickassSearchContext.isEnabled())) {
            return this.searchContextVisibilityChecker.FilterOutNonVisibleInContext(searchContext, allValues);
        }
        return allValues;
    }

    private List<TerminalClause> getMatchingClauses(Set<String> jqlClauseNames, Query query) {
        NamedTerminalClauseCollectingVisitor clauseVisitor = new NamedTerminalClauseCollectingVisitor(jqlClauseNames);
        if (query != null && query.getWhereClause() != null) {
            query.getWhereClause().accept(clauseVisitor);
            return clauseVisitor.getNamedClauses();
        }
        return Collections.emptyList();
    }
}

