/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.jql.util.JqlCustomFieldId;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@PublicApi
public final class ClauseNames {
    private final String primaryName;
    private final Set<String> names;

    public ClauseNames(String primaryName) {
        this(primaryName, Collections.emptySet());
    }

    public ClauseNames(String primaryName, String ... names) {
        this(primaryName, new LinkedHashSet<Object>(Arrays.asList((Object[])Assertions.notNull("names", names))));
    }

    public ClauseNames(String primaryName, Set<String> names) {
        TreeSet<String> newNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        newNames.addAll((Collection)Assertions.containsNoBlanks("names", names));
        this.primaryName = Assertions.notBlank("primaryName", primaryName);
        newNames.add(this.primaryName);
        this.names = Collections.unmodifiableSet(newNames);
    }

    public Set<String> getJqlFieldNames() {
        return this.names;
    }

    public String getPrimaryName() {
        return this.primaryName;
    }

    public boolean contains(String name) {
        return this.names.contains(name);
    }

    public static ClauseNames forCustomField(CustomField field) {
        Assertions.notNull("field", field);
        String name = field.getName();
        if (!SystemSearchConstants.isSystemName(name) && !JqlCustomFieldId.isJqlCustomFieldId(name)) {
            return new ClauseNames(JqlCustomFieldId.toString(field.getIdAsLong()), name);
        }
        return new ClauseNames(JqlCustomFieldId.toString(field.getIdAsLong()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClauseNames names1 = (ClauseNames)o;
        if (this.names != null ? !((Object)this.names).equals(names1.names) : names1.names != null) {
            return false;
        }
        return !(this.primaryName != null ? !this.primaryName.equals(names1.primaryName) : names1.primaryName != null);
    }

    public int hashCode() {
        int result = this.primaryName != null ? this.primaryName.hashCode() : 0;
        result = 31 * result + (this.names != null ? ((Object)this.names).hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

