/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.util.JiraUrlCodec;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.codehaus.jackson.annotate.JsonProperty;

public class IssueTypeJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String id;
    @JsonProperty
    private String description;
    @JsonProperty
    private String iconUrl;
    @JsonProperty
    private String name;
    @JsonProperty
    private boolean subtask;

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSubtask() {
        return this.subtask;
    }

    public void setSubtask(boolean subtask) {
        this.subtask = subtask;
    }

    public static Collection<IssueTypeJsonBean> shortBeans(Collection<IssueType> issuetypes, final JiraBaseUrls urls) {
        return Collections2.transform(issuetypes, (Function)new Function<IssueType, IssueTypeJsonBean>(){

            public IssueTypeJsonBean apply(IssueType from) {
                return IssueTypeJsonBean.shortBean(from, urls);
            }
        });
    }

    public static IssueTypeJsonBean shortBean(IssueType issuetype, JiraBaseUrls urls) {
        String iconAbsoluteUrl;
        if (issuetype == null) {
            return null;
        }
        try {
            iconAbsoluteUrl = new URL(issuetype.getIconUrl()).toString();
        }
        catch (MalformedURLException e) {
            iconAbsoluteUrl = urls.baseUrl() + issuetype.getIconUrl();
        }
        IssueTypeJsonBean bean = new IssueTypeJsonBean();
        bean.self = urls.restApi2BaseUrl() + "issuetype/" + JiraUrlCodec.encode(issuetype.getId().toString());
        bean.id = issuetype.getId().toString();
        bean.description = issuetype.getDescTranslation();
        bean.name = issuetype.getNameTranslation();
        bean.subtask = issuetype.isSubTask();
        bean.iconUrl = iconAbsoluteUrl;
        return bean;
    }

    public static IssueTypeJsonBean shortBean(String self, String id, String name, String description, boolean subtask, String iconUrl) {
        IssueTypeJsonBean bean = new IssueTypeJsonBean();
        bean.self = self;
        bean.id = id;
        bean.name = name;
        bean.description = description;
        bean.subtask = subtask;
        bean.iconUrl = iconUrl;
        return bean;
    }
}

