/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.ofbiz.AbstractOfBizValueWrapper;
import com.opensymphony.module.propertyset.PropertySet;
import java.sql.Timestamp;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

@PublicApi
public class Attachment
extends AbstractOfBizValueWrapper {
    private static final Logger log = Logger.getLogger(Attachment.class);
    private final IssueManager issueManager;
    private PropertySet attachmentProperties;

    public Attachment(IssueManager issueManager, GenericValue genericValue, PropertySet attachmentProperties) {
        super(genericValue);
        this.issueManager = issueManager;
        this.attachmentProperties = attachmentProperties;
    }

    public Attachment(IssueManager issueManager, GenericValue genericValue) {
        this(issueManager, genericValue, null);
    }

    public Issue getIssueObject() {
        return this.issueManager.getIssueObject(this.genericValue.getLong("issue"));
    }

    public GenericValue getIssue() {
        return this.issueManager.getIssue(this.genericValue.getLong("issue"));
    }

    public Long getId() {
        return this.genericValue.getLong("id");
    }

    public String getMimetype() {
        return this.genericValue.getString("mimetype");
    }

    public String getFilename() {
        return this.genericValue.getString("filename");
    }

    public Timestamp getCreated() {
        return this.genericValue.getTimestamp("created");
    }

    public Long getFilesize() {
        return this.genericValue.getLong("filesize");
    }

    public String getAuthor() {
        return this.genericValue.getString("author");
    }

    public PropertySet getProperties() {
        return this.attachmentProperties;
    }

    public Boolean isZip() {
        if (this.getGenericValue().get("zip") == null) {
            return null;
        }
        return this.genericValue.getInteger("zip") != 0;
    }

    public Boolean isThumbnailable() {
        if (this.getGenericValue().get("thumbnailable") == null) {
            return null;
        }
        return this.genericValue.getInteger("thumbnailable") != 0;
    }
}

