/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.renderer;

import com.atlassian.annotations.Internal;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.CustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.searchers.renderer.CustomFieldRenderer;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.KickassSearchContext;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.util.UserSearcherHelper;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptor;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import webwork.action.Action;

@Internal
public class GroupCustomFieldSearchRenderer
extends CustomFieldRenderer {
    private final CustomField field;
    private final UserSearcherHelper userSearcherHelper;
    private final UserUtil userUtil;

    public GroupCustomFieldSearchRenderer(ClauseNames clauseNames, CustomFieldSearcherModuleDescriptor customFieldSearcherModuleDescriptor, CustomField field, CustomFieldValueProvider customFieldValueProvider, FieldVisibilityManager fieldVisibilityManager) {
        super(clauseNames, customFieldSearcherModuleDescriptor, field, customFieldValueProvider, fieldVisibilityManager);
        this.field = field;
        this.userSearcherHelper = ComponentAccessor.getComponent(UserSearcherHelper.class);
        this.userUtil = ComponentAccessor.getComponent(UserUtil.class);
    }

    @Override
    public String getViewHtml(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        boolean kickass = this.isKickass();
        params.put("isKickass", kickass);
        if (kickass) {
            CustomFieldParams customFieldParams = (CustomFieldParams)fieldValuesHolder.get(this.field.getId());
            if (customFieldParams != null) {
                Collection groupNames = customFieldParams.getAllValues();
                List<Group> groups = this.transformUserInput(groupNames);
                params.put("values", groups);
            }
            return super.getViewHtml(searchContext, fieldValuesHolder, displayParameters, action, params);
        }
        return super.getViewHtml(user, searchContext, fieldValuesHolder, displayParameters, action);
    }

    @Override
    public String getEditHtml(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("isKickass", this.isKickass());
        CustomFieldParams customFieldParams = (CustomFieldParams)fieldValuesHolder.get(this.field.getId());
        if (customFieldParams != null) {
            Collection groupNames = customFieldParams.getAllValues();
            List<Group> groups = this.transformUserInput(groupNames);
            params.put("values", groups);
        }
        this.userSearcherHelper.addGroupSuggestionParams(user, params);
        return super.getEditHtml(searchContext, fieldValuesHolder, displayParameters, action, params);
    }

    public List<Group> transformUserInput(Collection<String> values) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (String groupName : values) {
            Group group = this.userUtil.getGroupObject(groupName);
            if (group == null) continue;
            groups.add(group);
        }
        Collections.sort(groups);
        return groups;
    }

    public boolean isKickass() {
        KickassSearchContext kickassSearchContext = ComponentAccessor.getComponent(KickassSearchContext.class);
        return kickassSearchContext.isEnabled();
    }
}

