/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.util.UriValidator;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.action.RedirectSanitiser;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicApi
public final class SafeRedirectChecker
implements RedirectSanitiser {
    private static final Logger log = LoggerFactory.getLogger(SafeRedirectChecker.class);
    private static final Logger securityLog = LoggerFactory.getLogger((String)"com.atlassian.jira.login.security");
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final UriValidator uriValidator;

    @Deprecated
    public SafeRedirectChecker(VelocityRequestContextFactory velocityRequestContextFactory) {
        this(velocityRequestContextFactory, ComponentAccessor.getComponent(UriValidator.class));
    }

    public SafeRedirectChecker(VelocityRequestContextFactory velocityRequestContextFactory, UriValidator uriValidator) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.uriValidator = uriValidator;
    }

    public boolean canRedirectTo(@Nullable String redirectUri) {
        if (redirectUri == null) {
            return true;
        }
        try {
            URI uri = new URI(redirectUri);
            return (uri.getScheme() == null || redirectUri.startsWith(this.getCanonicalBaseURL())) && !redirectUri.startsWith("//");
        }
        catch (URISyntaxException e) {
            log.debug("Failed to parse URI '{}', redirect will not be allowed", (Object)redirectUri);
            return false;
        }
    }

    @Override
    @Nullable
    public String makeSafeRedirectUrl(@Nullable String redirectUrl) {
        if (redirectUrl == null) {
            return null;
        }
        String safeRedirectUrl = this.uriValidator.getSafeUri(this.getCanonicalBaseURL(), redirectUrl);
        if (safeRedirectUrl == null) {
            securityLog.warn("Potential XSS attempt detected. Malicious URL: " + redirectUrl);
            return null;
        }
        if (!this.canRedirectTo(safeRedirectUrl)) {
            securityLog.warn("Potential phishing attempt detected. Malicious URL: " + redirectUrl);
            return null;
        }
        return safeRedirectUrl;
    }

    protected String getCanonicalBaseURL() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
    }
}

