/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.annotations.Internal;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.ContextSetUtil;
import com.atlassian.jira.jql.context.ValidatingDecoratorContextFactory;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.validator.OperatorUsageValidator;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import java.util.HashSet;
import java.util.List;

@Internal
public class MultiClauseDecoratorContextFactory
implements ClauseContextFactory {
    private final ClauseContextFactory delegate;
    private final JqlOperandResolver jqlOperandResolver;
    private final ContextSetUtil contextSetUtil;

    public MultiClauseDecoratorContextFactory(JqlOperandResolver jqlOperandResolver, ClauseContextFactory delegate) {
        this(jqlOperandResolver, delegate, ContextSetUtil.getInstance());
    }

    public MultiClauseDecoratorContextFactory(JqlOperandResolver jqlOperandResolver, ClauseContextFactory delegate, ContextSetUtil contextSetUtil) {
        this.contextSetUtil = Assertions.notNull("contextSetUtil", contextSetUtil);
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
        this.delegate = Assertions.notNull("delegate", delegate);
    }

    @Override
    public final ClauseContext getClauseContext(User searcher, TerminalClause terminalClause) {
        Operand operand = terminalClause.getOperand();
        List<QueryLiteral> literals = this.jqlOperandResolver.getValues(searcher, operand, terminalClause);
        if (literals == null || literals.isEmpty()) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        Operator convertedOperator = MultiClauseDecoratorContextFactory.convertListOperator(terminalClause.getOperator());
        if (convertedOperator == null || !this.jqlOperandResolver.isListOperand(operand)) {
            return this.delegate.getClauseContext(searcher, terminalClause);
        }
        HashSet<ClauseContext> ctxs = new HashSet<ClauseContext>();
        for (QueryLiteral literal : literals) {
            Operand newOperand;
            if (literal.isEmpty()) {
                newOperand = EmptyOperand.EMPTY;
            } else {
                if (literal.getLongValue() == null && literal.getStringValue() == null) continue;
                newOperand = new SingleValueOperand(literal);
            }
            TerminalClauseImpl newClause = new TerminalClauseImpl(terminalClause.getName(), convertedOperator, newOperand);
            ctxs.add(this.delegate.getClauseContext(searcher, newClause));
        }
        if (convertedOperator == Operator.EQUALS) {
            return this.contextSetUtil.union(ctxs);
        }
        return this.contextSetUtil.intersect(ctxs);
    }

    private static Operator convertListOperator(Operator operator) {
        if (operator == Operator.IN) {
            return Operator.EQUALS;
        }
        if (operator == Operator.NOT_IN) {
            return Operator.NOT_EQUALS;
        }
        return null;
    }

    public static class Factory {
        private final OperatorUsageValidator validator;
        private final JqlOperandResolver resolver;
        private final ContextSetUtil contextSetUtil;

        public Factory(OperatorUsageValidator validator, JqlOperandResolver resolver, ContextSetUtil contextSetUtil) {
            this.contextSetUtil = Assertions.notNull("contextSetUtil", contextSetUtil);
            this.validator = Assertions.notNull("validator", validator);
            this.resolver = Assertions.notNull("resolver", resolver);
        }

        @NotNull
        public ClauseContextFactory create(@NotNull ClauseContextFactory delegate) {
            return this.create(delegate, true);
        }

        @NotNull
        public ClauseContextFactory create(@NotNull ClauseContextFactory delegate, boolean validating) {
            ClauseContextFactory factory = new MultiClauseDecoratorContextFactory(this.resolver, Assertions.notNull("delegate", delegate), this.contextSetUtil);
            if (validating) {
                factory = new ValidatingDecoratorContextFactory(this.validator, factory);
            }
            return factory;
        }
    }
}

