/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.util.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class UserUtils {
    public static boolean userExists(String username) {
        return UserUtils.getUser(username) != null;
    }

    public static User getUser(String username) {
        return UserUtils.getUserManager().getUserObject(username);
    }

    public static User getUserEvenWhenUnknown(String username) {
        return UserUtils.getUserManager().getUserEvenWhenUnknown(username);
    }

    public static User getUserByEmail(String emailAddress) {
        if ((emailAddress = StringUtils.trimToNull((String)emailAddress)) == null) {
            return null;
        }
        for (User user : UserUtils.getAllUsers()) {
            if (!emailAddress.equalsIgnoreCase(user.getEmailAddress())) continue;
            return user;
        }
        return null;
    }

    public static List getUsersByEmail(String email) {
        ArrayList<User> users = new ArrayList<User>();
        String emailAddress = StringUtils.trimToNull((String)email);
        if (emailAddress != null) {
            for (User user : UserUtils.getAllUsers()) {
                if (!emailAddress.equalsIgnoreCase(user.getEmailAddress())) continue;
                users.add(user);
            }
        }
        return users;
    }

    public static Collection<User> getAllUsers() {
        return UserUtils.getUserManager().getUsers();
    }

    public static UserManager getUserManager() {
        return ComponentAccessor.getUserManager();
    }
}

