/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue;

import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.Map;

@PublicApi
public interface IssueService {
    public IssueResult getIssue(User var1, Long var2);

    public IssueResult getIssue(User var1, String var2);

    public CreateValidationResult validateSubTaskCreate(User var1, Long var2, IssueInputParameters var3);

    public CreateValidationResult validateCreate(User var1, IssueInputParameters var2);

    public IssueResult create(User var1, CreateValidationResult var2);

    public IssueResult create(User var1, CreateValidationResult var2, String var3);

    public IssueResult update(User var1, UpdateValidationResult var2);

    public UpdateValidationResult validateUpdate(User var1, Long var2, IssueInputParameters var3);

    public IssueResult update(User var1, UpdateValidationResult var2, EventDispatchOption var3, boolean var4);

    public DeleteValidationResult validateDelete(User var1, Long var2);

    public ErrorCollection delete(User var1, DeleteValidationResult var2);

    public ErrorCollection delete(User var1, DeleteValidationResult var2, EventDispatchOption var3, boolean var4);

    public boolean isEditable(Issue var1, User var2);

    public TransitionValidationResult validateTransition(User var1, Long var2, int var3, IssueInputParameters var4);

    public IssueResult transition(User var1, TransitionValidationResult var2);

    public AssignValidationResult validateAssign(User var1, Long var2, String var3);

    public IssueResult assign(User var1, AssignValidationResult var2);

    public IssueInputParameters newIssueInputParameters();

    public IssueInputParameters newIssueInputParameters(Map<String, String[]> var1);

    @PublicApi
    public static abstract class IssueValidationResult
    extends ServiceResultImpl {
        private final MutableIssue issue;

        public IssueValidationResult(MutableIssue issue, ErrorCollection errors) {
            super(errors);
            this.issue = issue;
        }

        public MutableIssue getIssue() {
            return this.issue;
        }
    }

    public static class TransitionValidationResult
    extends ServiceResultImpl {
        private final MutableIssue issue;
        private final Map additionInputs;
        private final Map<String, Object> fieldValuesHolder;
        private final int actionId;

        public TransitionValidationResult(MutableIssue issue, ErrorCollection errors, Map<String, Object> fieldValuesHolder, Map additionInputs, int actionId) {
            super(errors);
            this.issue = issue;
            this.fieldValuesHolder = fieldValuesHolder;
            this.additionInputs = additionInputs;
            this.actionId = actionId;
        }

        public MutableIssue getIssue() {
            return this.issue;
        }

        public Map getAdditionInputs() {
            return this.additionInputs;
        }

        public int getActionId() {
            return this.actionId;
        }

        public Map<String, Object> getFieldValuesHolder() {
            return this.fieldValuesHolder;
        }
    }

    @PublicApi
    public static class IssueResult
    extends IssueValidationResult {
        public IssueResult(MutableIssue issue) {
            super(issue, new SimpleErrorCollection());
        }

        public IssueResult(MutableIssue issue, ErrorCollection errors) {
            super(issue, errors);
        }
    }

    public static class DeleteValidationResult
    extends IssueValidationResult {
        public DeleteValidationResult(MutableIssue issue, ErrorCollection errors) {
            super(issue, errors);
        }
    }

    public static class AssignValidationResult
    extends IssueValidationResult {
        private String assigneeId;

        public AssignValidationResult(MutableIssue issue, ErrorCollection errors, String assigneeId) {
            super(issue, errors);
            this.assigneeId = assigneeId;
        }

        public String getAssigneeId() {
            return this.assigneeId;
        }
    }

    public static class UpdateValidationResult
    extends IssueValidationResult {
        private Map<String, Object> fieldValuesHolder;

        public UpdateValidationResult(MutableIssue issue, ErrorCollection errors, Map<String, Object> fieldValuesHolder) {
            super(issue, errors);
            this.fieldValuesHolder = fieldValuesHolder;
        }

        public Map<String, Object> getFieldValuesHolder() {
            return this.fieldValuesHolder;
        }
    }

    public static class CreateValidationResult
    extends IssueValidationResult {
        private Map<String, Object> fieldValuesHolder;

        public CreateValidationResult(MutableIssue issue, ErrorCollection errors, Map<String, Object> fieldValuesHolder) {
            super(issue, errors);
            this.fieldValuesHolder = fieldValuesHolder;
        }

        public Map<String, Object> getFieldValuesHolder() {
            return this.fieldValuesHolder;
        }
    }
}

